% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/vcgPlyWrite.r
\name{vcgPlyWrite}
\alias{vcgPlyWrite}
\alias{vcgPlyWrite.matrix}
\alias{vcgPlyWrite.mesh3d}
\title{Export meshes to PLY-files}
\usage{
vcgPlyWrite(mesh, filename, binary = TRUE, ...)

\method{vcgPlyWrite}{mesh3d}(mesh, filename = dataname, binary = TRUE,
  addNormals = FALSE, writeCol = TRUE, ...)

\method{vcgPlyWrite}{matrix}(mesh, filename = dataname, binary = TRUE, ...)
}
\arguments{
\item{mesh}{triangular mesh of class 'mesh3d' or a numeric matrix with 3-columns}

\item{filename}{character: filename (file extension '.ply' will be added automatically.}

\item{binary}{logical: write binary file}

\item{addNormals}{logical: compute per-vertex normals and add to file}

\item{writeCol}{logical: export existing per-vertex color stored in mesh$material$color}

\item{\dots}{additional arguments, currently not used.}
}
\description{
Export meshes to PLY-files (binary or ascii)
}
\examples{
data(humface)
vcgPlyWrite(humface,filename = "humface")
}

