% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normorient.r
\name{checkFaceOrientation}
\alias{checkFaceOrientation}
\title{check the orientation of a mesh}
\usage{
checkFaceOrientation(x, offset = NULL)
}
\arguments{
\item{x}{mesh of class mesh3d}

\item{offset}{numeric: amount to offset the mesh along the vertex normals. If NULL a reasonable value will be estimated.}
}
\value{
returns TRUE if mesh is oriented correctly and FALSE otherwise
}
\description{
check the orientation of a mesh assuming that expansion along normals increases centroid size
}
\details{
assuming that a correctly (i.e outward) oriented mesh increases its centroid size when 'growing' outwards, this function tests whether this is the case.
}
\examples{
data(dummyhead)
## now we invert faces inwards
checkFaceOrientation(dummyhead.mesh)
dummyinward <- Morpho::invertFaces(dummyhead.mesh)
checkFaceOrientation(dummyinward)
}

