% Generated by roxygen2 (4.0.1): do not edit by hand
\name{vcgSmooth}
\alias{vcgSmooth}
\title{Smoothes a triangular mesh}
\usage{
vcgSmooth(mesh, type = c("taubin", "laplace", "HClaplace", "fujiLaplace",
  "angWeight"), iteration = 10, lambda = 0.5, mu = -0.53, delta = 0.1)
}
\arguments{
\item{mesh}{triangular mesh stored as object of class "mesh3d".}

\item{type}{character: select smoothing algorithm. Available are "taubin",
"laplace", "HClaplace", "fujiLaplace", "angWeight" (and any sensible
abbreviations).}

\item{iteration}{integer: number of iterations to run.}

\item{lambda}{numeric: parameter for Taubin smooth (see reference below).}

\item{mu}{numeric:parameter for Taubin smooth (see reference below).}

\item{delta}{numeric: parameter for Scale dependent laplacian smoothing (see
reference below).}
}
\value{
returns an object of class "mesh3d" with:
\item{vb }{4xn matrix containing n vertices as homolougous coordinates.}
\item{normals}{4xn matrix containing vertex normals.}
\item{quality }{vector: containing distances to target.}
\item{it }{4xm matrix containing vertex indices forming triangular
faces.}
}
\description{
Applies different smoothing algorithms on a triangular mesh.
}
\details{
The algorithms available are Taubin smoothing, Laplacian smoothing and an
improved version of Laplacian smoothing ("HClaplace"). Also available are
Scale dependent laplacian smoothing ("fujiLaplace") and Laplacian angle
weighted smoothing ("angWeight")
}
\note{
The additional parameters for taubin smooth are hardcoded to the
default values of meshlab, as they appear to be the least distorting
}
\examples{
data(humface)
smoothface <- vcgSmooth(humface)
## view
\dontrun{
require(rgl)
shade3d(smoothface, col=3)
}
}
\author{
Stefan Schlager
}
\references{
Taubin G. 1995. Curve and surface smoothing without shrinkage.
In Computer Vision, 1995. Proceedings., Fifth International Conference on,
pages 852 - 857.

Vollmer J., Mencl R. and Mueller H. 1999. Improved Laplacian Smoothing of
Noisy Surface Meshes. Computer Graphics Forum, 18(3):131 - 138.

Schroeder, P. and Barr, A. H. (1999). Implicit fairing of irregular meshes
using diffusion and curvature flow: 317-324.
}
\seealso{
\code{\link{vcgPlyRead},\link{vcgClean}}
}
\keyword{~kwd1}
\keyword{~kwd2}

