% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxJacobian.R
\name{.rxGenEtaS}
\alias{.rxGenEtaS}
\title{Generate the ETA sensitivities for FO related methods}
\usage{
.rxGenEtaS(
  obj,
  predfn,
  pkpars = NULL,
  errfn = NULL,
  init = NULL,
  promoteLinSens = TRUE,
  theta = FALSE,
  addProp = c("combined2", "combined1")
)
}
\arguments{
\item{obj}{RxODE object}

\item{predfn}{Prediction function}

\item{pkpars}{Pk Pars function}

\item{errfn}{Error function}

\item{init}{Initialization parameters for scaling.}

\item{promoteLinSens}{Promote solved linear compartment systems to
sensitivity-based solutions.}

\item{theta}{Calculate THETA derivatives instead of ETA
derivatives.  By default FALSE}

\item{addProp}{one of "combined1" and "combined2"; These are the
two forms of additive+proportional errors supported by
monolix/nonmem:

combined1: transform(y)=transform(f)+(a+b*f^c)*eps

combined2: transform(y)=transform(f)+(a^2+b^2*f^(2c))*eps}
}
\value{
RxODE/symengine environment
}
\description{
Generate the ETA sensitivities for FO related methods
}
\author{
Matthew L. Fidler
}
