% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xnat_api.R
\name{download_xnat_file}
\alias{download_xnat_file}
\title{Download XNAT file}
\usage{
download_xnat_file(conn, ...)
}
\arguments{
\item{conn}{The XNAT connection returned by a \code{xnat_connect} call}

\item{...}{file_path Path to the file to be downloaded
destfile Destination filename
prefix Prefix the file name with this (prevents
overwriting of same name files in case function is
used to download multiple scan types at once)
verbose Should progress be added to download?
error Should function error if download failed?}
}
\value{
Display path to the downloaded file
}
\description{
Download a single file from XNAT
}
\examples{
## file_path is retrieved using the get_scan_resources() function
\donttest{xnat_central_conn <- xnat_connect('https://central.xnat.org', xnat_name="CENTRAL")}
\donttest{r <- get_scan_resources(xnat_central_conn,'CENTRAL_E00760')}
\donttest{download_xnat_file(xnat_central_conn,r$URI[1])}
}
