test_that("xnat_api", {
  skip_on_cran()
  testthat::expect_silent(nitrc <- xnat_connect('https://nitrc.org/ir'))
  testthat::expect_is(nitrc$jsid, "character")
  testthat::expect_true(nitrc$is.connected())
  testthat::expect_is(nitrc$projects(), "data.frame")
  testthat::expect_is(nitrc$subjects(), "data.frame")
  testthat::expect_is(nitrc$experiments(), "data.frame")
  testthat::expect_is(nitrc$get_xnat_experiment_resources('xnat_E00026'), "data.frame")
  testthat::expect_gt(nrow(query_scan_resources(nitrc,age="26")),0)
  testthat::expect_gt(nrow(get_scan_resources(nitrc,'xnat_E00026')),0)
  testthat::expect_equal(basename(download_xnat_file(nitrc,"/data/experiments/xnat_E00026/scans/anat_mprage_anonymized/resources/3967/files/scan_mprage_anonymized.nii.gz",file_dir = tempdir())),"scan_mprage_anonymized.nii.gz")
  testthat::expect_null(download_xnat_dir(nitrc, experiment_ID='xnat_E00026',scan_type='T2', file_dir = tempdir(), verbose=TRUE))
  testthat::expect_equal(basename(download_xnat_dir(nitrc, experiment_ID='NITRC_IR_E10507',scan_type='T2', file_dir = tempdir(), verbose=TRUE)), "NITRC_IR_E10507.zip")
})