% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R, R/S3.R
\docType{data}
\name{base_classes}
\alias{base_classes}
\alias{class_logical}
\alias{class_integer}
\alias{class_double}
\alias{class_complex}
\alias{class_character}
\alias{class_raw}
\alias{class_list}
\alias{class_expression}
\alias{class_function}
\alias{class_environment}
\alias{class_numeric}
\alias{class_atomic}
\alias{class_vector}
\alias{class_factor}
\alias{class_Date}
\alias{class_POSIXct}
\alias{class_data.frame}
\title{Base classes}
\usage{
class_logical

class_integer

class_double

class_complex

class_character

class_raw

class_list

class_expression

class_function

class_environment

class_numeric

class_atomic

class_vector

class_factor

class_Date

class_POSIXct

class_data.frame
}
\value{
S7 classes wrapping around common base types and S3 classes.
}
\description{
These classes represent base types allowing them to be used within S7.
There are three categories: base types, unions types, and key S3 classes.

Base types:
\itemize{
\item \code{class_logical}
\item \code{class_integer}
\item \code{class_double}
\item \code{class_complex}
\item \code{class_character}
\item \code{class_raw}
\item \code{class_list}
\item \code{class_expression}
\item \code{class_function}
\item \code{class_environment} (can only be used for properties)
}

Union types:
\itemize{
\item \code{class_numeric} is a union of \code{class_integer} and \code{class_double}.
\item \code{class_atomic} is a union of \code{class_logical}, \code{class_numeric},
\code{class_complex}, \code{class_character}, and \code{class_raw}.
\item \code{class_vector} is a union of \code{class_atomic}, \code{class_list}, and
\code{class_expression}.
}

Key S3 classes:
\itemize{
\item \code{class_data.frame}
\item \code{class_Date}
\item \code{class_factor}
\item \code{class_POSIXct}
}
}
\examples{

class_integer
class_numeric
class_factor
}
\keyword{datasets}
