% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalReal.R
\name{evalReal}
\alias{evalReal}
\title{Evaluate new iterate on real function(s)}
\usage{
evalReal(
  cobra,
  ev1,
  xNew,
  fValue,
  feval,
  optimConv,
  optimTime,
  currentEps,
  fitnessSurrogate = cobra$fitnessSurrogate
)
}
\arguments{
\item{cobra}{an object of class COBRA, this is a (long) list containing all settings
from \code{\link{cobraPhaseII}}}

\item{ev1}{a list, initially empty, gradually filled by calls to \code{evalReal}}

\item{xNew}{the new point, see \code{\link{cobraPhaseII}}}

\item{fValue}{fitness value estimated for  \code{xNew}}

\item{feval}{function evaluations on surrogates needed by COBRA optimizer}

\item{optimConv}{see \code{\link{cobraPhaseII}}}

\item{optimTime}{see \code{\link{cobraPhaseII}}}

\item{currentEps}{artificial current margin for the equality constraints: A point is said to be 
\strong{artificially feasible}, if \eqn{h_j(x) - currentEps \le 0,    -h_j(x) - currentEps \le 0,} 
for all equality constraints and if it is feasible in the inequality constraints.}

\item{fitnessSurrogate}{[\code{cobra$fitnessSurrogate}]   see \code{\link{cobraPhaseII}}}
}
\value{
\code{ev1}, a list with the following \code{n}-dim vectors ( \code{n} = number of
     iterations, the last element is from the new iterate / point \code{xNew} ):
     \item{\code{predY}}{  prediction of  \code{fitnessSurrogate} at \code{xNew}}
     \item{\code{predVal}}{ \code{fvalue} (fitness + penalty in case of NMKB et al.)}
     \item{\code{feval}}{  function evaluations on surrogates needed by COBRA optimizer }
     \item{\code{optimizerConvergence}}{ see \code{\link{cobraPhaseII}} }
     \item{\code{optimizationTime}}{ see \code{\link{cobraPhaseII}} }
     \item{\code{predC}}{ prediction of  \code{cobra$constraintSurrogates} at \code{xNew} }
     \item{\code{feas}}{  TRUE, if \code{xNew} is feasible for the current constraints}
     \item{\code{feasPred}}{ TRUE, if \code{xNew} is feasible for \code{cobra$constraintSurrogates} }
     In addition, \code{ev1} has these elements:
     \item{\code{xNew}}{  \code{d}-dim vector, the new point, refined in the case of equality handling}
     \item{\code{xNewEval}}{  \code{cobra$fn(xNew)}, an \code{(1+nConstraints)}-dim vector 
                 (objective,constraints) }
     \item{\code{newNumViol}}{  scalar, the number of constraint violations (above 
                 \code{cobra$conTol}) on true constraints from \code{xNewEval} }
     \item{\code{newNumPred}}{  scalar, the number of constraint violations (above 
                 \code{cobra$conTol}) on constraint surrogates for \code{xNew} }
     \item{\code{newMaxViol}}{  scalar, the maximum constraint violation (with  
                 \code{currentEps} subtracted) on true constraints from \code{xNewEval} }
     \item{\code{trueMaxViol}}{  scalar, the maximum constraint violation (w/o  
                 \code{currentEps} subtracted) on true constraints from \code{xNewEval} }
                 
     If \code{cobra$equHandle$active==TRUE}, then the last four values are for \code{xNew} after 
     the refine step. In this case, the first three elements \code{newNumViol}, \code{newNumPred},
     and \code{newMaxViol} refer to the artificially enlarged equality constraints, i.e.
         \deqn{ h_j(x) - currentEps \le 0,    -h_j(x) - currentEps \le 0, }
     and the true inequality constraints \eqn{max(0,g_i(x))}. The last element \code{trueMaxViol}  
     measures the maximum violation among the true equality constraints \eqn{|h_j(x)|} and the  
     true inequality constraints \eqn{max(0,g_i(x))}.
}
\description{
Helper for \code{\link{cobraPhaseII}}: The new iterate \code{xNew}, which was found by optimization
on the surrogate models, is evaluated on the real function \code{cobra$fn}. In the case of equality
constraints, \code{evalReal} does the additional refine step (see Details).
}
\details{
If \code{cobra$equHandle$active==TRUE}, then \code{xNew} is first \strong{refined}: The artificially feasible
solution \code{xNew} is replaced by a refined solution \code{ev1$xNew}. 
\code{ev1$xNew} is created by using \code{optim} to minimize the function 
   \deqn{ \sum_i{\max(0,g_i(x))} + \sum_j{h_j^2(x) } } 
Ideally, the refined solution \code{ev1$xNew} should be \strong{on} the equality constraints 
(within machine accuracy), but there is no guarantee that \code{optim} reaches this desired result.
}
\seealso{
\code{\link{cobraPhaseII}}
}
