% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr_predict.R
\name{expr.predict}
\alias{expr.predict}
\title{Calculates SAVER prediction.}
\usage{
expr.predict(x, y, pred.cells = 1:length(y), seed = NULL,
  lambda.max = NULL, lambda.min = NULL)
}
\arguments{
\item{x}{A log-normalized expression count matrix of genes to be used in the
prediction.}

\item{y}{A normalized expression count vector of the gene to be predicted.}

\item{pred.cells}{Index of cells to use for prediction. Default is to use
all cells.}

\item{seed}{Sets the seed for reproducible results.}

\item{lambda.max}{Maximum value of lambda which gives null model.}

\item{lambda.min}{Value of lambda from which the prediction model is
used}
}
\value{
A vector of predicted gene expression.
}
\description{
Uses \code{cv.glmnet} from the \code{glmnet} package to return the SAVER
prediction.
}
\details{
The SAVER method starts with predicting the prior mean for each cell for a
specific gene. The prediction is performed using the observed normalized
gene count as the response and the normalized gene counts of other genes as
predictors. \code{cv.glmnet} from the \code{glmnet} package is used to fit
the LASSO Poisson regression. The model with the lowest cross-validation
error is chosen and the fitted response values are returned and used as the
SAVER prediction.
}
