% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_ViolinPlot.R
\name{do_ViolinPlot}
\alias{do_ViolinPlot}
\title{Wrapper for \link[Seurat]{VlnPlot}.}
\usage{
do_ViolinPlot(
  sample,
  features,
  assay = NULL,
  slot = NULL,
  group.by = NULL,
  split.by = NULL,
  colors.use = NULL,
  pt.size = 0,
  line_width = 1,
  y_cut = rep(NA, length(features)),
  plot_boxplot = TRUE,
  boxplot_width = 0.2,
  legend.position = "none",
  plot.title = NULL,
  plot.subtitle = NULL,
  plot.caption = NULL,
  xlab = rep(NA, length(features)),
  ylab = rep(NA, length(features)),
  font.size = 14,
  font.type = "sans",
  rotate_x_axis_labels = 45,
  plot.grid = TRUE,
  grid.color = "grey75",
  grid.type = "dashed",
  flip = FALSE,
  ncol = NULL,
  share.y.lims = FALSE
)
}
\arguments{
\item{sample}{\strong{\code{\link[SeuratObject]{Seurat}}} | A Seurat object, generated by \link[Seurat]{CreateSeuratObject}.}

\item{features}{\strong{\code{\link[base]{character}}} | Features to represent.}

\item{assay}{\strong{\code{\link[base]{character}}} | Assay to use. Defaults to the current assay.}

\item{slot}{\strong{\code{\link[base]{character}}} | Data slot to use. Only one of: counts, data, scale.data. Defaults to "data".}

\item{group.by}{\strong{\code{\link[base]{character}}} | Metadata variable to group the output by. Has to be a character of factor column.}

\item{split.by}{\strong{\code{\link[base]{character}}} | Secondary metadata variable to further group (split) the output by. Has to be a character of factor column.}

\item{colors.use}{\strong{\code{\link[SCpubr]{named_vector}}} | Named vector of valid color representations (either name of HEX codes) with as many named colors as unique values of group.by. If group.by is not provided, defaults to the unique values of \link[Seurat]{Idents}. If not provided, a color scale will be set by default.}

\item{pt.size}{\strong{\code{\link[base]{numeric}}} | Size of points in the Violin plot.}

\item{line_width}{\strong{\code{\link[base]{numeric}}} | Width of the lines drawn in the plot. Defaults to 1.}

\item{y_cut}{\strong{\code{\link[base]{numeric}}} | Vector with the values in which the Violins should be cut. Only works for one feature.}

\item{plot_boxplot}{\strong{\code{\link[base]{logical}}} | Whether to plot a Box plot inside the violin or not.}

\item{boxplot_width}{\strong{\code{\link[base]{numeric}}} | Width of the boxplots. Defaults to 0.2.}

\item{legend.position}{\strong{\code{\link[base]{character}}} | Position of the legend in the plot. One of:
\itemize{
\item \emph{\code{top}}: Top of the figure.
\item \emph{\code{bottom}}: Bottom of the figure.
\item \emph{\code{left}}: Left of the figure.
\item \emph{\code{right}}: Right of the figure.
\item \emph{\code{none}}: No legend is displayed.
}}

\item{plot.title, plot.subtitle, plot.caption}{\strong{\code{\link[base]{character}}} | Title, subtitle or caption to use in the plot.}

\item{xlab, ylab}{\strong{\code{\link[base]{character}}} | Titles for the X and Y axis.}

\item{font.size}{\strong{\code{\link[base]{numeric}}} | Overall font size of the plot. All plot elements will have a size relationship with this font size.}

\item{font.type}{\strong{\code{\link[base]{character}}} | Base font family for the plot. One of:
\itemize{
\item \emph{\code{mono}}: Mono spaced font.
\item \emph{\code{serif}}: Serif font family.
\item \emph{\code{sans}}: Default font family.
}}

\item{rotate_x_axis_labels}{\strong{\code{\link[base]{numeric}}} | Degree to rotate the X labels. One of: 0, 45, 90.}

\item{plot.grid}{\strong{\code{\link[base]{logical}}} | Whether to plot grid lines.}

\item{grid.color}{\strong{\code{\link[base]{character}}} | Color of the grid in the panels.}

\item{grid.type}{\strong{\code{\link[base]{character}}} | One of the possible linetype options:
\itemize{
\item \emph{\code{blank}}.
\item \emph{\code{solid}}.
\item \emph{\code{dashed}}.
\item \emph{\code{dotted}}.
\item \emph{\code{dotdash}}.
\item \emph{\code{longdash}}.
\item \emph{\code{twodash}}.
}}

\item{flip}{\strong{\code{\link[base]{logical}}} | Whether to invert the axis of the displayed plot.}

\item{ncol}{\strong{\code{\link[base]{numeric}}} | Number of columns used in the arrangement of the output plot using "split.by" parameter.}

\item{share.y.lims}{\strong{\code{\link[base]{logical}}} | When querying multiple features, force the Y axis of all of them to be on the same range of values (this being the max and min of all features combined).}
}
\value{
A ggplot2 object containing a Violin Plot.
}
\description{
Wrapper for \link[Seurat]{VlnPlot}.
}
\examples{
\donttest{
  # Check Suggests.
  value <- SCpubr:::check_suggests(function_name = "do_ViolinPlot", passive = TRUE)

  if (isTRUE(value)){
    # Consult the full documentation in https://enblacar.github.io/SCpubr-book/

    # Define your Seurat object.
    sample <- readRDS(system.file("extdata/seurat_dataset_example.rds", package = "SCpubr"))

    # Basic violin plot.
    p <- SCpubr::do_ViolinPlot(sample = sample,
                               feature = "nCount_RNA")
    p

    # Remove the box plots.
    p <- SCpubr::do_ViolinPlot(sample = sample,
                               feature = "nCount_RNA",
                               plot_boxplot = FALSE)
    p

  } else if (isFALSE(value)){
    message("This function can not be used without its suggested packages.")
    message("Check out which ones are needed using `SCpubr::state_dependencies()`.")
  }
}
}
