% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_functions.R
\name{SDADiscretePred}
\alias{SDADiscretePred}
\title{SDADiscretePred function}
\usage{
SDADiscretePred(
  para_est,
  control.mcmc = NULL,
  divisor = 1,
  plot.correlogram = FALSE,
  messages = TRUE
)
}
\arguments{
\item{para_est}{an object of class "SDALGCP" obtained as a result of a call to \code{\link{SDALGCPMCML}}.}

\item{control.mcmc}{output from \code{\link{controlmcmcSDA}}, if not provided, it uses the values used for the parameter estimation}

\item{divisor}{optional, if the coordinate of the shapefile is rescaled, default is 1}

\item{plot.correlogram}{logical; if plot.correlogram=TRUE the autocorrelation plot of the conditional simulations is displayed.}

\item{messages}{logical; if messages=TRUE then status messages are printed on the screen (or output device) while the function is running. Default is messages=TRUE.}
}
\value{
It returns the following list

S.draw: the samples of the linear predictor \eqn{d(x)'\beta + S(A)}

incidence: the region-specific incidence

SEincidence: Standard error of the region-specific incidence

CovRR: the prediction of the covariate adjusted relative risk

SECovRR: the standard error of the covariate adjusted relative risk
}
\description{
This function performs spatial discrete prediction for a fixed the model parameters at the Monte Carlo maximum likelihood estimates of a SDALGCP model.
}
\details{
The function returns the region-specific incidence and the covariate adjusted relative risk exp(S(A))
}
\author{
Olatunji O. Johnson \email{o.johnson@lancaster.ac.uk}

Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
\keyword{internal}
