% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estVmax.R
\name{est.vmax}
\alias{est.vmax}
\title{Estimate maximum linear speed (Vmax)}
\usage{
est.vmax(sdata, qi = 5, prob = 0.99)
}
\arguments{
\item{sdata}{A data frame containing columns with the following headers: "id", "DateTime", "lat", "lon", "qi". 
This filter is independently applied to a subset of data grouped by the unique "id". 
"DateTime" is date & time in class POSIXct. "lat" and "lon" are the recorded latitude and longitude in decimal degrees. 
"qi" is the numerical quality index associated with each fix where the greater number represents better quality 
(e.g. number of GPS satellites used for estimation).}

\item{qi}{An integer specifying minimum quality index associated with a location used for the estimation. Default is 5.}

\item{prob}{Numeric vector of a probability to obtain sample quantiles. Default is 0.99.}
}
\value{
A vector is returned. The unit is in kilometres per hour.
}
\description{
This function estimates the maximum linear speed between two consecutive locations as described in Shimada et al. (2012)
}
\details{
The function first calculates the linear speeds between each pair of two consecutive locations. 
It discards extreme values based on the quantile specified by a user (default is 0.99). 
This is to deal with outliers potentially contained in the original data set. 
The maximum value in the retained dataset (i.e. without outliers) represents the maximum linear speed at which 
an animal would travel between two consecutive locations.
}
\note{
Input data must not contain temporal or spatial duplicates.
}
\references{
Shimada T, Jones R, Limpus C, Hamann M (2012) 
Improving data retention and home range estimates by data-driven screening. 
Marine Ecology Progress Series 457:171-180 doi:10.3354/meps09747
}
\seealso{
ddfilter, ddfilter.speed
}
\author{
Takahiro Shimada
}
