#' Records of \emph{Brisaster antarcticus} echinoid presences on the Kerguelen Plateau
#'
#' @description Dataset that contains the presence of the echinoid species \emph{Brisaster antarcticus} reported on the Kerguelen Plateau (63/81W; -46/-56S) during the campaigns of the RV Marion Dufresne MD03 1974 & MD04 1975, POKER 2 (2010) campaigns and the program PROTEKER (2013, 2014, 2015).  \cr \emph{Brisaster antarcticus} (Doderlein 1906) is distributed from 3.5 to 75.6W and -53.35 to -45.95S in the Southern Ocean. The species is mainly found around Kerguelen and Crozet Islands. \emph{Brisaster antarcticus} commonly lives from 100 to 600 meters depth. \cr It is a detrivorous species for which reproduction includes dispersal (David et al. 2005).
#'
#' See Guillaumot et al. (submitted) for more details.
#'
#'
#' @usage data(brisaster.antarcticus)
#'
#'@format A data frame containing 43 occurrences and 13 descriptive variables
#'\itemize{
#' \item \emph{id}                         \cr   Occurrence number indicator
#' \item \emph{scientific.name}           \cr   Species scientific name
#' \item \emph{scientific.name.authorship}   \cr   Author of the species description
#' \item \emph{genus}                       \cr Genus scientific name and its associated author
#' \item \emph{family}                      \cr Family scientific name and its associated author
#' \item \emph{order.and.higher.taxonomic.range} \cr Order scientific name and its associated author
#' \item \emph{decimal.Longitude}           \cr Longitude in decimal degrees
#' \item \emph{decimal.Latitude}            \cr Latitude in decimal degrees
#' \item \emph{depth}                       \cr Depth in meters
#' \item \emph{campaign}                    \cr Campaign origin of the data
#' \item \emph{reference}                   \cr Campaign reference
#' \item \emph{vessel}                      \cr Campaign vessel}
#'


#'@references
#'David B, Chone T, Mooi R, De Ridder C (2005) Antarctic Echinoidea. Synopses of the Antarctic Benthos 10.
#'
#'Doderlein L (1906) Die Echinoiden der Deutschen Tiefsee-Expedition. Deutsche Tiefsee Expedition 1898-1899. 5: 63-290.
#'
#'Guillaumot C, A Martin, S Fabri-Ruiz, M Eleaume & T Saucede. Echinoids of the Kerguelen Plateau: Occurrence data and environmental setting for past, present, and future species distribution modelling, Zookeys, Manuscript submitted for publication.
#'
#'@examples
#'data(brisaster.antarcticus)
#'x <- brisaster.antarcticus
#'
#'# plot of the occurrences:
#'# selecting the species according to the campaigns
#'brisaster7475 <- subset(x,x$year==1974 | x$year==1975)
#'brisaster20102015 <- subset(x,x$campaign=='POKER II'| x$campaign=='PROTEKER')
#'
#'# drawing the background (depth)
#'library(grDevices)
#'blue.palette <- colorRampPalette(c('blue','deepskyblue','azure'))(100)
#'data('predictors1965_1974')
#'depth <- raster :: subset(predictors1965_1974, 1)
#'
#'raster::plot(depth, col=blue.palette,main= "Brisaster antarcticus occurrences")
#'
#'# adding the occurrence data to the background
#'points(brisaster7475[,c('decimal.Longitude','decimal.Latitude')],
#'       col='orange',pch=16)
#'points(brisaster20102015[,c('decimal.Longitude','decimal.Latitude')],
#'       col='darkgreen',pch=16)
#'legend('bottomleft',
#'        legend=c('Brisaster antarcticus 1974-1975','Brisaster antarcticus 2010-2015'),
#'        col= c('orange','darkgreen'), pch= c(15, 15),cex=0.9)
#'
#'
"brisaster.antarcticus"



