% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotResponse.R
\name{plotResponse}
\alias{plotResponse}
\title{Plot Response Curve}
\usage{
plotResponse(model, var, type = NULL, only_presence = FALSE,
  marginal = FALSE, fun = mean, rug = FALSE, color = "red")
}
\arguments{
\item{model}{\code{\linkS4class{SDMmodel}} or \code{\linkS4class{SDMmodelCV}}
object.}

\item{var}{character. Name of the variable to be plotted.}

\item{type}{character. The output type used for "Maxent" and "Maxnet"
methods, possible values are "cloglog" and "logistic", default is
\code{NULL}.}

\item{only_presence}{logical, if \code{TRUE} it uses only the presence
locations when applying the function for the marginal response, default is
\code{FALSE}.}

\item{marginal}{logical, if \code{TRUE} it plots the marginal response curve,
default is \code{FALSE}.}

\item{fun}{function used to compute the level of the other variables for
marginal curves, default is \code{mean}.}

\item{rug}{logical, if \code{TRUE} it adds the rug plot for the presence and
absence/background locations, available only for continuous variables,
default is \code{FALSE}.}

\item{color}{The color of the curve, default is "red".}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
Plot the Response Curve of the given environmental variable.
}
\details{
Note that fun is not a character argument, you must use \code{mean}
and not \code{"mean"}.
}
\examples{
\donttest{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence and background locations
p_coords <- virtualSp$presence
bg_coords <- virtualSp$background

# Create SWD object
data <- prepareSWD(species = "Virtual species", p = p_coords, a = bg_coords,
                   env = predictors, categorical = "biome")

# Train a model
model <- train(method = "Maxnet", data = data, fc = "l")

# Plot cloglog response curve for a continuous environmental variable (bio1)
plotResponse(model, var = "bio1", type = "cloglog")

# Plot marginal cloglog response curve for a continuous environmental
# variable (bio1)
plotResponse(model, var = "bio1", type = "cloglog", marginal = TRUE)

# Plot logistic response curve for a continuous environmental variable
# (bio12) adding the rugs and giving a custom color
plotResponse(model, var = "bio12", type = "logistic", rug = TRUE,
             color = "blue")

# Plot response curve for a categorical environmental variable (biome) giving
# a custom color
plotResponse(model, var = "biome", type = "logistic", color = "green")

# Train a model with cross validation
model <- train(method = "Maxnet", p = presence, a = bg, fc = "lq", rep = 4)

# Plot cloglog response curve for a continuous environmental variable (bio17)
plotResponse(model, var = "bio1", type = "cloglog")

# Plot logistic response curve for a categorical environmental variable
# (biome) giving a custom color
plotResponse(model, var = "biome", type = "logistic", color = "green")
}
}
\author{
Sergio Vignali
}
