% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rsd}
\alias{rsd}
\title{Root Square Difference}
\usage{
rsd(x, o, g, d, s, ymax, xlab, color)
}
\arguments{
\item{x}{a column vector of scores on which the rsd is conditioned}

\item{o}{a column vector of equated scores based on the overall population (aligned with elements in x)}

\item{g}{a column vector of equated scores based on a single subpopulation (aligned with elements in x)}

\item{d}{a scalar of the difference that matters}

\item{s}{a scalar representing the standard deviation of x for any (sub)population of interest (e.g., synthetic population) (default is 1, which leads to calculation of the unstandardized rsd)}

\item{ymax}{A maximum value for the y axis of the plot (default = 3 + the maximum RSD value)}

\item{xlab}{A label for the x axis of the plot (default = Score Scale)}

\item{color}{of RSD line and points on plot (default = red)}
}
\value{
A data frame of root square difference indices, conditioned on the score scale

A plot of the RSD in reference to the difference that matters
}
\description{
The root square difference index (\eqn{RSD}{RSD}) is a conditional index of the absolute differences between a single subpopulation \eqn{j}{j}'s equated score, \eqn{y_j(x)}{y_j(x)}, and the equated score based on the overall population, \eqn{y(x)}{y(x)}. Formally, 
\deqn{RSD_j(x)=\frac{\mid y_j(x)-y(x)\mid}{\sigma_x},}{RSDj(x)=|y_j(x)-y(x)|/s,}
where \eqn{x}{x} is a score on the original (i.e., unequated) scale, and \eqn{\sigma_x}{s} is the standard deviation of x scores in the (sub)population of interest. It is considered a group-to-overall, conditional index. It was adapted from Yang's \eqn{RESD_j}{RESDj} (2004) by Huggins and Penfield (2012). It provides practitioners with the magnitude of differences between a single subpopulation's equated scores and the equated score based on the overall population, at each score level on the original score scale.
}
\examples{
#Unstandardized RSD for subpopulation 1 in the example data set, ex.data
rsd(x=ex.data[,1],o=ex.data[,2],g=ex.data[,3],d=.5)

#Unstandardized RSD for subpopulation 5 in the example data set, ex.data
rsd(x=ex.data[,1],o=ex.data[,2],g=ex.data[,7],d=.5)

#Unstandardized RSD for subpopulation 5 in the example data set, ex.data 
#with adjustments to the maximum y-axis on the plot, a new x label, 
#and points/line in green
rsd(x=ex.data[,1],o=ex.data[,2],g=ex.data[,7],d=.5,ymax=3,xlab="Old Form",color="green")

#Standardized RSD for subpopulation 5 in the example data set, ex.data
rsd(x=ex.data[,1],o=ex.data[,2],g=ex.data[,7],d=.5,s=4.2)
}
\author{
Anne Corinne Huggins-Manley
}
\references{
\itemize{
\item{Huggins, A.C., & Penfield, R.D. (2012). An NCME instructional module on population invariance in linking and equating. Educational Measurement: Issues and Practices, 31, 27-40.}
\item{Yang, W.L. (2004). Sensitivity of linkings between AP multiple-choice scores and composite scores to geographical region: An illustration of checking for population invariance. Journal of Educational Measurement, 41, 33-41.}
}
}
\seealso{
\code{\link{resd}}
}

