% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toxicIntensity.R
\docType{methods}
\name{toxicIntensity}
\alias{toxicIntensity}
\alias{toxicIntensity,Landscape-method}
\title{toxicIntensity Method}
\usage{
toxicIntensity(objectL, ...)

\S4method{toxicIntensity}{Landscape}(objectL, toxic_emission, mintime = 1,
  maxtime = 60, size_raster = 2^10, kernel = "NIG",
  kernel.options = list(a1 = 0.2073, a2 = 0.2073, b1 = 0.3971, b2 = 0.3971, b3
  = 0.0649, theta = 0), beta = 0.4, alpha = list(minalpha = 0.1, maxalpha =
  0.95, covariate_threshold = 30, simulate = T, covariate = NULL))
}
\arguments{
\item{objectL}{A Landscape object}

\item{...}{parameters}

\item{toxic_emission}{Matrix of sources emissions, row as sources ID, col as time}

\item{mintime}{Start simulation time (default=1)}

\item{maxtime}{End simulation time}

\item{size_raster}{raster size (default = 2^10)}

\item{kernel}{dispersion kernel, function name (default = NIG)}

\item{kernel.options}{parameters list for the kernel function}

\item{beta}{toxic adherence parameter between 0 and 1 (default = 0.4)}

\item{alpha}{list of toxic loss options

(default = list(minalpha=0.1,maxalpha=0.95,covariate_threshold=30,simulate=TRUE,covariate=NULL))}
}
\value{
A ToxicIntensityRaster, a 3D array as time matrix dispersion, [t,x,y]
}
\description{
Simulate contaminants intensity over the landscape by two steps : dispersal of toxic particules and local intensity of particules after dispersal.
}
\details{
The dispersal of contaminants is implemented by rastering the landscape and by computing the convolution between sources emissions and a dispersal kernel.

The dispersion kernel by default is Normal Inverse Gaussian kernel ("NIG" function). Currently, two others are implemented "geometric" (with parameter \code{a}) and "2Dt" kernels (with parameters \code{a}, \code{b}, \code{c1}, \code{c2}).

Local intensity depends of \code{beta} and \code{alpha} parameters. Beta represents the toxic adherence between [0,1].
Alpha represents a list of parameters of the lost of toxic particules due to covariates (precipitation).
There are two configurations to integrate the loss in the function : 
(i) simulating covariate (simulate=TRUE) or (ii) uploading covariate (simulate=FALSE).
The covariate is linked to the loss by a linear regression with paramaters minalpha, maxalpha, covariate_threshold.
}

