% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{getCsdGeno}
\alias{getCsdGeno}
\alias{getQueenCsdGeno}
\alias{getFathersCsdGeno}
\alias{getVirginQueensCsdGeno}
\alias{getWorkersCsdGeno}
\alias{getDronesCsdGeno}
\title{Get genotypes from the csd locus}
\usage{
getCsdGeno(
  x,
  caste = NULL,
  nInd = NULL,
  dronesHaploid = TRUE,
  collapse = FALSE,
  simParamBee = NULL
)

getQueenCsdGeno(x, collapse = FALSE, simParamBee = NULL)

getFathersCsdGeno(
  x,
  nInd = NULL,
  dronesHaploid = TRUE,
  collapse = FALSE,
  simParamBee = NULL
)

getVirginQueensCsdGeno(x, nInd = NULL, collapse = FALSE, simParamBee = NULL)

getWorkersCsdGeno(x, nInd = NULL, collapse = FALSE, simParamBee = NULL)

getDronesCsdGeno(
  x,
  nInd = NULL,
  dronesHaploid = TRUE,
  collapse = FALSE,
  simParamBee = NULL
)
}
\arguments{
\item{x}{\code{\link[AlphaSimR]{Pop-class}}, \code{\link[SIMplyBee]{Colony-class}}, or
\code{\link[SIMplyBee]{MultiColony-class}}}

\item{caste}{NULL or character, NULL when \code{x} is a \code{\link[AlphaSimR]{Pop-class}},
and character when \code{x} is a \code{\link[SIMplyBee]{Colony-class}} or
 \code{\link[SIMplyBee]{MultiColony-class}} with the possible values of "queen", "fathers",
 "workers", "drones", "virginQueens", or "all"}

\item{nInd}{numeric, for how many individuals; if \code{NULL} all individuals
are taken; this can be useful as a test of sampling individuals}

\item{dronesHaploid}{logical, return haploid result for drones?}

\item{collapse}{logical, if the return value should be a single matrix
with haplotypes of all the individuals}

\item{simParamBee}{\code{\link[SIMplyBee]{SimParamBee}}, global simulation parameters}
}
\value{
matrix with genotypes when \code{x} is \code{\link[AlphaSimR]{Pop-class}}, list
  of matrices with genotypes when \code{x} is \code{\link[SIMplyBee]{Colony-class}}
  (list nodes named by caste) and list of a list of matrices with genotypes
  when \code{x} is \code{\link[SIMplyBee]{MultiColony-class}}, outer list is named by
  colony id when \code{x} is \code{\link[SIMplyBee]{MultiColony-class}}; \code{NULL} when
  \code{x} is \code{NULL}
}
\description{
Level 0 function that returns genotypes from the csd locus. See
  \code{\link[SIMplyBee]{SimParamBee}} for more information about the csd locus and how
  we have implemented it.
}
\details{
The returned genotypes are spanning multiple bi-allelic SNP of
  a non-recombining csd locus / haplotype. In most cases you will want to use
  \code{\link[SIMplyBee]{getCsdAlleles}}.
}
\section{Functions}{
\itemize{
\item \code{getQueenCsdGeno()}: Access csd genotypes of the queen

\item \code{getFathersCsdGeno()}: Access csd genotypes of the fathers

\item \code{getVirginQueensCsdGeno()}: Access csd genotypes of the virgin queens

\item \code{getWorkersCsdGeno()}: Access csd genotypes of the virgin queens

\item \code{getDronesCsdGeno()}: Access csd genotypes of the virgin queens

}}
\examples{
founderGenomes <- quickHaplo(nInd = 8, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
colony <- buildUp(x = colony, nWorkers = 6, nDrones = 3)
colony <- addVirginQueens(x = colony, nInd = 4)

apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])
apiary <- buildUp(x = apiary, nWorkers = 6, nDrones = 3)
apiary <- addVirginQueens(x = apiary, nInd = 5)

# Use getCsdGeno on a Population
getCsdGeno(getQueen(colony))
getCsdGeno(getWorkers(colony))

# Using dronesHaploid = TRUE returns drones as haploids instead of double haploids
getCsdGeno(getDrones(colony), nInd = 3, dronesHaploid = TRUE)
# Using dronesHaploid = FALSE returns drones as double haploids
getCsdGeno(getDrones(colony), nInd = 3, dronesHaploid = FALSE)

# Use getCsdGeno on a Colony
getCsdGeno(colony)
getCsdGeno(colony, caste = "queen")
getQueenCsdGeno(colony)
getCsdGeno(colony, caste = "workers")
getWorkersCsdGeno(colony)
# Same aliases exist for all the castes!

# Use getCsdGeno on a MultiColony - same behaviour as for the Colony!
getCsdGeno(apiary)
getCsdGeno(apiary, nInd = 2)
}
