% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{getEvents}
\alias{getEvents}
\title{Report which colony events have occurred}
\usage{
getEvents(x)
}
\arguments{
\item{x}{\code{\link[SIMplyBee]{Colony-class}} or \code{\link[SIMplyBee]{MultiColony-class}}}
}
\value{
matrix of logicals, named by colony id when \code{x} is
  \code{\link[SIMplyBee]{MultiColony-class}}
}
\description{
Level 0 function that returns a matrix of logicals reporting the
  status of the colony events. The events are: split, swarm, supersedure,
  collapse, and production. These events impact colony status, strength, and
  could also impact downstream phenotypes.
}
\examples{
founderGenomes <- quickHaplo(nInd = 8, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
colony <- buildUp(x = colony, nWorkers = 6, nDrones = 3)
colony <- addVirginQueens(colony, nInd = 5)

apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])
apiary <- buildUp(x = apiary, nWorkers = 6, nDrones = 3)
apiary <- addVirginQueens(apiary, nInd = 4)

getEvents(colony)
getEvents(apiary)

tmp <- swarm(colony)
getEvents(tmp$swarm)
getEvents(tmp$remnant)

apiary <- supersede(apiary)
getEvents(apiary)
}
