% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{isFathersPresent}
\alias{isFathersPresent}
\alias{areFathersPresent}
\title{Are fathers present (=queen mated)}
\usage{
isFathersPresent(x, simParamBee = NULL)

areFathersPresent(x, simParamBee = NULL)
}
\arguments{
\item{x}{\code{\link[SIMplyBee]{Colony-class}} or \code{\link[SIMplyBee]{MultiColony-class}}}

\item{simParamBee}{\code{\link[SIMplyBee]{SimParamBee}}, global simulation parameters}
}
\value{
logical, named by colony id when \code{x} is
  \code{\link[SIMplyBee]{MultiColony-class}}
}
\description{
Level 0 function that returns fathers presence status (are they
  present or not, which means the queen is mated).
}
\section{Functions}{
\itemize{
\item \code{areFathersPresent()}: Are fathers present

}}
\examples{
founderGenomes <- quickHaplo(nInd = 8, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
isFathersPresent(colony)
apiary <- createMultiColony(basePop[3:4], n = 2)
isFathersPresent(apiary)

colony <- cross(colony, drones = droneGroups[[1]])
isFathersPresent(removeDrones(colony))

apiary <- cross(apiary, drones = droneGroups[c(2, 3)])
isFathersPresent(removeDrones(apiary))
}
