% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L1_Pop.R
\name{pullCastePop}
\alias{pullCastePop}
\alias{pullQueen}
\alias{pullWorkers}
\alias{pullDrones}
\alias{pullVirginQueens}
\title{Pull individuals from a caste in a colony}
\usage{
pullCastePop(
  x,
  caste,
  nInd = NULL,
  use = "rand",
  removeFathers = TRUE,
  collapse = FALSE,
  simParamBee = NULL
)

pullQueen(x, collapse = FALSE, simParamBee = NULL)

pullWorkers(x, nInd = NULL, use = "rand", collapse = FALSE, simParamBee = NULL)

pullDrones(
  x,
  nInd = NULL,
  use = "rand",
  removeFathers = TRUE,
  collapse = FALSE,
  simParamBee = NULL
)

pullVirginQueens(
  x,
  nInd = NULL,
  use = "rand",
  collapse = FALSE,
  simParamBee = NULL
)
}
\arguments{
\item{x}{\code{\link[SIMplyBee]{Colony-class}} or \code{\link[SIMplyBee]{MultiColony-class}}}

\item{caste}{character, "queen", "workers", "drones", or "virginQueens"}

\item{nInd}{numeric, number of individuals to pull, if \code{NULL} all
individuals are pulled. If input is \code{\link[SIMplyBee]{MultiColony-class}},
the input could also be a vector of the same length as the number of colonies. If
a single value is provided, the same value will be applied to all the colonies.}

\item{use}{character, all options provided by \code{\link[AlphaSimR]{selectInd}}}

\item{removeFathers}{logical, removes \code{drones} that have already mated;
set to \code{FALSE} if you would like to get drones for mating with multiple
virgin queens, say via insemination}

\item{collapse}{logical, whether to return a single merged population
for the pulled individuals (does not affect the remnant colonies)}

\item{simParamBee}{\code{\link[SIMplyBee]{SimParamBee}}, global simulation parameters}
}
\value{
list of \code{\link[AlphaSimR]{Pop-class}} and \code{\link[SIMplyBee]{Colony-class}}
  when \code{x} is \code{\link[SIMplyBee]{Colony-class}} and list of (a list of
  \code{\link[AlphaSimR]{Pop-class}} named by colony id) and
  \code{\link[SIMplyBee]{MultiColony-class}} when \code{x} is
  \code{\link[SIMplyBee]{MultiColony-class}}
}
\description{
Level 1 function that pulls individuals from a caste in a
  colony. These individuals are removed from the colony (compared to
  \code{\link[SIMplyBee]{getCaste}}).
}
\section{Functions}{
\itemize{
\item \code{pullQueen()}: Pull queen from a colony

\item \code{pullWorkers()}: Pull workers from a colony

\item \code{pullDrones()}: Pull drones from a colony

\item \code{pullVirginQueens()}: Pull virgin queens from a colony

}}
\examples{
founderGenomes <- quickHaplo(nInd = 8, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
colony <- buildUp(x = colony, nWorkers = 100, nDrones = 10, exact = TRUE)
colony <- addVirginQueens(x = colony, nInd = 3)

apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])
apiary <- buildUp(x = apiary, nWorkers = 100, nDrones = 10, exact = TRUE)
apiary <- addVirginQueens(x = apiary, nInd = 3)

# pullCastePop on Colony class
# We can't pull the queen and leave the colony queenless
pullCastePop(colony, caste = "virginQueens")
pullCastePop(colony, caste = "virginQueens", nInd = 2)
# Or use aliases
pullVirginQueens(colony)
pullVirginQueens(colony, nInd = 2)
# Same aliases exist for all the castes!!!

# pullCastePop on MultiColony class - same behaviour as for the Colony!
pullCastePop(apiary, caste = "workers")
# Or pull out unequal number of workers from colonies
pullCastePop(apiary, caste = "workers", nInd = c(10, 20))
pullWorkers(apiary)
nWorkers(apiary)
nWorkers(pullWorkers(apiary)$remnant)


# Merge all the pulled populations into a single population
pullCastePop(apiary, caste = "queen", collapse = TRUE)
pullCastePop(apiary, caste = "virginQueens", collapse = TRUE)
}
\seealso{
\code{\link[SIMplyBee]{pullQueen}}, \code{\link[SIMplyBee]{pullVirginQueens}},
  \code{\link[SIMplyBee]{pullWorkers}}, and \code{\link[SIMplyBee]{pullDrones}}
}
