% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{heart}
\alias{heart}
\title{Heart disease}
\format{
270 observations from 17 variables represented as a list consisting
of a binary factor response vector \code{y},
with levels 'absence' and 'presence' indicating the absence or presence of
heart disease and \code{x}: a sparse feature matrix of class 'dgCMatrix' with the
following variables:
\describe{
\item{age}{age}
\item{bp}{diastolic blood pressure}
\item{chol}{serum cholesterol in mg/dl}
\item{hr}{maximum heart rate achieved}
\item{old_peak}{ST depression induced by exercise relative to rest}
\item{vessels}{the number of major blood vessels (0 to 3) that were
colored by fluoroscopy}
\item{sex}{sex of the participant: 0 for male, 1 for female}
\item{angina}{a dummy variable indicating whether the person suffered
angina-pectoris during exercise}
\item{glucose_high}{indicates a fasting blood sugar over 120 mg/dl}
\item{cp_typical}{typical angina}
\item{cp_atypical}{atypical angina}
\item{cp_nonanginal}{non-anginal pain}
\item{ecg_abnormal}{indicates a ST-T wave abnormality
(T wave inversions and/or ST elevation or depression of
> 0.05 mV)}
\item{ecg_estes}{probable or definite left ventricular hypertrophy by
Estes' criteria}
\item{slope_flat}{a flat ST curve during peak exercise}
\item{slope_downsloping}{a downwards-sloping ST curve during peak exercise}
\item{thal_reversible}{reversible defect}
\item{thal_fixed}{fixed defect}
}
}
\source{
Dua, D. and Karra Taniskidou, E. (2017). UCI Machine Learning Repository
\url{http://archive.ics.uci.edu/ml}. Irvine, CA: University of California,
School of Information and Computer Science.

\url{https://www.csie.ntu.edu.tw/~cjlin/libsvmtools/datasets/binary.html#heart}
}
\usage{
heart
}
\description{
Diagnostic attributes of patients classified as having heart disease or not.
}
\section{Preprocessing}{

The original dataset contained 13 variables. The nominal of these were
dummycoded, removing the first category. No precise information regarding
variables \code{chest_pain}, \code{thal} and \code{ecg} could be found, which explains
their obscure definitions here.
}

\seealso{
Other datasets: 
\code{\link{abalone}},
\code{\link{bodyfat}},
\code{\link{student}},
\code{\link{wine}}
}
\concept{datasets}
\keyword{datasets}
