% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R,
%   R/S3_RelativeRootMeanSquaredError.R
\name{rrmse.numeric}
\alias{rrmse.numeric}
\alias{weighted.rrmse.numeric}
\alias{rrmse}
\alias{weighted.rrmse}
\title{Relative Root Mean Squared Error}
\usage{
\method{rrmse}{numeric}(actual, predicted, normalization = 1L, ...)

\method{weighted.rrmse}{numeric}(actual, predicted, w, normalization = 1L, ...)

## Generic S3 method
rrmse(
 actual,
 predicted,
 normalization = 1,
 ...
)

## Generic S3 method
weighted.rrmse(
 actual,
 predicted,
 w,
 normalization = 1,
 ...
)
}
\arguments{
\item{actual}{A <\link{numeric}>-vector of \link{length} \eqn{n}. The observed (continuous) response variable.}

\item{predicted}{A <\link{numeric}>-vector of \link{length} \eqn{n}. The estimated (continuous) response variable.}

\item{normalization}{A <\link{numeric}>-value of \link{length} \eqn{1} (default: \eqn{1}). \eqn{0}: \link{mean}-normalization, \eqn{1}: \link{range}-normalization, \eqn{2}: \link{IQR}-normalization.}

\item{...}{Arguments passed into other methods.}

\item{w}{A <\link{numeric}>-vector of \link{length} \eqn{n}. The weight assigned to each observation in the data.}
}
\value{
A <\link{numeric}> vector of \link{length} 1.
}
\description{
The \code{\link[=rrmse]{rrmse()}}-function computes the \href{https://en.wikipedia.org/wiki/Root-mean-square_deviation}{Relative Root Mean Squared Error} between
the observed and predicted <\link{numeric}> vectors. The \code{\link[=weighted.rrmse]{weighted.rrmse()}} function computes the weighted Relative Root Mean Squared Error.
}
\section{Definition}{


The metric is calculated as,

\deqn{
  \frac{RMSE}{\gamma}
}

Where \eqn{\gamma} is the normalization factor.
}

\examples{
# 1) fit a linear
# regression
model <- lm(
  mpg ~ .,
  data = mtcars
)

# 1.1) define actual
# and predicted values
# to measure performance
actual    <- mtcars$mpg
predicted <- fitted(model)

# 2) evaluate in-sample model
# performance using Relative Root Mean Squared Error (RRMSE)
cat(
  "IQR Relative Root Mean Squared Error", rrmse(
    actual        = actual,
    predicted     = predicted,
    normalization = 2
  ),
  "IQR Relative Root Mean Squared Error (weighted)", weighted.rrmse(
    actual        = actual,
    predicted     = predicted,
    w             = mtcars$mpg/mean(mtcars$mpg),
    normalization = 2
  ),
  sep = "\n"
)

}
\seealso{
Other Regression: 
\code{\link{ccc.numeric}()},
\code{\link{huberloss.numeric}()},
\code{\link{mae.numeric}()},
\code{\link{mape.numeric}()},
\code{\link{mpe.numeric}()},
\code{\link{mse.numeric}()},
\code{\link{pinball.numeric}()},
\code{\link{rae.numeric}()},
\code{\link{rmse.numeric}()},
\code{\link{rmsle.numeric}()},
\code{\link{rrse.numeric}()},
\code{\link{rsq.numeric}()},
\code{\link{smape.numeric}()}

Other Supervised Learning: 
\code{\link{ROC.factor}()},
\code{\link{accuracy.factor}()},
\code{\link{baccuracy.factor}()},
\code{\link{ccc.numeric}()},
\code{\link{ckappa.factor}()},
\code{\link{cmatrix.factor}()},
\code{\link{dor.factor}()},
\code{\link{entropy.matrix}()},
\code{\link{fbeta.factor}()},
\code{\link{fdr.factor}()},
\code{\link{fer.factor}()},
\code{\link{fpr.factor}()},
\code{\link{huberloss.numeric}()},
\code{\link{jaccard.factor}()},
\code{\link{logloss.factor}()},
\code{\link{mae.numeric}()},
\code{\link{mape.numeric}()},
\code{\link{mcc.factor}()},
\code{\link{mpe.numeric}()},
\code{\link{mse.numeric}()},
\code{\link{nlr.factor}()},
\code{\link{npv.factor}()},
\code{\link{pinball.numeric}()},
\code{\link{plr.factor}()},
\code{\link{pr.auc.matrix}()},
\code{\link{prROC.factor}()},
\code{\link{precision.factor}()},
\code{\link{rae.numeric}()},
\code{\link{recall.factor}()},
\code{\link{rmse.numeric}()},
\code{\link{rmsle.numeric}()},
\code{\link{roc.auc.matrix}()},
\code{\link{rrse.numeric}()},
\code{\link{rsq.numeric}()},
\code{\link{smape.numeric}()},
\code{\link{specificity.factor}()},
\code{\link{zerooneloss.factor}()}
}
\concept{Regression}
\concept{Supervised Learning}
