\name{SNSequate-package}
\alias{SNSequate-package}
\alias{SNSequate}
\docType{package}
\title{Standard and Nonstandard Statistical Models and Methods for Test
Equating
}

\description{The package contains functions to perform various models and 
	methods for test equating. It currently implements the traditional 
	mean, linear and equipercentile equating methods. Both IRT observed-score 
	and true-score equating are also supported, as well as the mean-mean, 
	mean-sigma, Haebara and Stocking-Lord IRT linking methods. 
	It also supports newest methods such that local equating, kernel 
	equating (using Gaussian, logistic, Epanechnikov, uniform and adaptive 
	kernels) with presmoothing, and IRT parameter linking methods based on 
	asymmetric item characteristic functions. Functions to obtain both 
	standard error of equating (SEE) and standard error of equating differences 
	between two equating functions (SEED) are also implemented for the kernel method of 
	equating.
}

\details{
\tabular{ll}{
Package: \tab SNSequate\cr
Type: \tab Package\cr
Version: \tab 1.3.3\cr
Date: \tab 2020-02-23\cr
License: \tab GPL (>= 2)\cr
}
}

\author{Jorge Gonzalez

Maintainer: Jorge Gonzalez <jorge.gonzalez@mat.uc.cl>

}

\references{

	Estay, G. (2012). \emph{Characteristic Curves Scale Transformation Methods Using 
	Asymmetric ICCs for IRT Equating}. Unpublished MSc. Thesis. Pontificia Universidad 
	Catolica de Chile.

	Gonzalez, J. (2013). Statistical Models and Inference for the True Equating Transformation in the 
	Context of Local Equating. \emph{Journal of Educational Measurement, 50(3),} 315-320.

  Gonzalez, J. (2014). SNSequate: Standard and Nonstandard Statistical Models and Methods for Test 
  Equating. \emph{Journal of Statistical Software, 59(7),} 1-30.
  
  Gonzalez, J. and Wiberg, M. (2017). Applying test equating methods using R. Springer.
	
	Holland, P. and Thayer, D. (1989). The kernel method of equating score distributions. 
	(Technical Report No 89-84). Princeton, NJ: Educational Testing Service.

	Holland, P., King, B. and Thayer, D. (1989). The standard error of equating for the kernel method 
	of equating score distributions (Tech. Rep. No. 89-83). Princeton, NJ: Educational Testing Service. 

	Kolen, M., and Brennan, R. (2004). \emph{Test Equating, Scaling and Linking}. 
	New York, NY: Springer-Verlag.

	Lord, F. (1980). \emph{Applications of Item Response Theory to Practical Testing Problems}. 
	Lawrence Erlbaum Associates, Hillsdale, NJ.

	Lord, F. and Wingersky, M. (1984). Comparison of IRT True-Score and Equipercentile Observed-Score Equatings. 
	\emph{Applied Psychological Measurement,8(4),} 453--461.

	van der Linden, W. (2011). Local Observed-Score Equating. In A. von Davier (Ed.) 
	\emph{Statistical Models for Test Equating, Scaling, and Linking}. New York, NY: Springer-Verlag.

	van der Linden, W. (2013). Some Conceptual Issues in Observed-Score Equating. 
	\emph{Journal of Educational Measurement, 50(3),} 249-285.

	Von Davier, A., Holland, P., and Thayer, D. (2004). \emph{The Kernel Method of Test Equating}. 
	New York, NY: Springer-Verlag.
}


\keyword{ package }

