\name{spotPredictDace}
\alias{spotPredictDace}
\title{Meta Model Interface: DACE Kriging}
\usage{
  spotPredictDace(rawB, mergedB, design, spotConfig,
    fit = NULL)
}
\arguments{
  \item{rawB}{unmerged data}

  \item{mergedB}{merged data (aggregation of repeated
  design points)}

  \item{design}{new design points which should be
  predicted}

  \item{spotConfig}{global list of all options, needed to
  provide data for calling functions. This also contains a
  list, with settings for Forrester:\cr
  \code{spotConfig$seq.dace.budget} Budget for MLE of
  parameters, default is 100. The value will be multiplied
  with the length of the model parameter vector to be
  optimized. (which means 100*i evaluations, where i
  depends on the problem dimension as well as the
  correlation function and whether a nugget value is to be
  determined)\cr \code{spotConfig$seq.dace.tol} Tolerance
  stopping criterion for MLE, default is 1e-6\cr
  \code{spotConfig$seq.dace.regr} Regression function to be
  used: \code{\link{regpoly0}} (default),
  \code{\link{regpoly1}}, \code{\link{regpoly2}}\cr
  \code{spotConfig$seq.dace.corr} Correlation function to
  be used: \code{\link{corrnoisykriging}} (default),
  \code{\link{corrkriging}}, \code{\link{corrnoisygauss}},
  \code{\link{corrgauss}}, \code{\link{correxp}},
  \code{\link{correxpg}}, \code{\link{corrlin}},
  \code{\link{corrcubic}},\code{\link{corrspherical}},\code{\link{corrspline}}\cr
  \code{spotConfig$seq.dace.nugget} Value for nugget.
  Default is -1, which means the nugget will be optimized
  during MLE. Else it can be fixed in a range between 0 and
  1.}

  \item{fit}{if an existing model fit is supplied, the
  model will not be build based on data, but only evaluated
  with the model fit (on the design data). To build the
  model, this parameter has to be NULL. If it is not NULL
  the parameters mergedB and rawB will not be used at all
  in the function.}
}
\value{
  returns the list \code{spotConfig} with two new
  entries:\cr spotConfig$seq.modelFit fit of the model used
  with dacePredictor \cr spotConfig$seq.largeDesignY the y
  values of the design, evaluated with the fit
}
\description{
  This Kriging meta model is based on DACE (Design and
  Analysis of Computer Experiments). It allows to choose
  different regression and correlation models. If multiple
  response variables are present, a DACE model for each
  will be created for the purpose of multi objective
  optimization.
}
\author{
  The authors of the original DACE Matlab toolbox
  \url{http://www2.imm.dtu.dk/~hbni/dace/} are Hans Bruun
  Nielsen \email{hbn@imm.dtu.dk}, Soren Nymand Lophaven and
  Jacob Sondergaard. \cr Extension of the Matlab code by
  Tobias Wagner \email{wagner@isf.de}. \cr Porting and
  adaptation to R and further extensions by Martin
  Zaefferer \email{martin.zaefferer@fh-koeln.de}.
}
\references{
  S.~Lophaven, H.~Nielsen, and J.~Sondergaard. {DACE---A
  Matlab Kriging Toolbox}. Technical Report
  IMM-REP-2002-12, Informatics and Mathematical Modelling,
  Technical University of Denmark, Copenhagen, Denmark,
  2002.
}
\seealso{
  \code{\link{dacePredictor}} \code{\link{daceBuilder}}
}

