% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funMarkovChain.R
\name{funMarkovChain}
\alias{funMarkovChain}
\title{funMarkovChain}
\usage{
funMarkovChain(x, conf)
}
\arguments{
\item{x}{vector of parameter values, i.e., parameters of the MarkovChain model to evaluate with the function.
\describe{
    \item{\code{p}}{num  [0;1] proportion of confirmed cases}
    \item{\code{beta}}{num Transmission rate from susceptible to infected. See \code{\link[SimInf]{SIR}}. }
    \item{\code{gamma}}{num Recovery rate from infected to recovered. See \code{\link[SimInf]{SIR}}. }
    \item{\code{CFR}}{num Case Fatalities Rate}
}}

\item{conf}{a list with entries 
\describe{
    \item{\code{regionData}}{ A data frame with observations of 3 variables:
     \describe{
             \item{\code{date}}{Date, format: "2020-01-22" "2020-01-23" "2020-01-24" "2020-01-25" ...}
             \item{\code{confirmed}}{num  0 0 0 0 0 0 0 0 0 0 ..}
             \item{\code{fatalities}}{fatalities: num  0 0 0 0 0 0 0 0 0 0 ...}
              }
     }
      \item{\code{N}}{N population size}
 }}
}
\value{
1-column matrix with resulting function values (RMSE)
}
\description{
Wrapper function for \code{\link{evalMarkovChain}} used by \code{\link{spot}}.
}
\details{
Optimization of Continuous Time Markov Chains (MarkovChain) models.
}
\examples{

# data <- preprocessInputData(regionTrain, regionPopulation)
# set.seed(123)
# data <- data[[1]]
# N <- attr(data, "regionPopulation")
## x = (p, beta, gamma, CFR)
# x <- matrix(c(0.01, 0.1, 0.01, 0.1),1,4)
# conf <- list(regionData = data, N = N)
# funMarkovChain(x, conf)

}
