% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ensemble.SDM.R
\docType{class}
\name{Ensemble.SDM-class}
\alias{Ensemble.SDM-class}
\title{An S4 class to represent an ensemble SDM}
\description{
This is an S4 class to represent an ensemble SDM from multiple algorithms
(including generalized linear model, general additive model, multivariate
adaptive splines, generalized boosted regression model, classification tree
analysis, random forest, maximum entropy, artificial neural network, and
support vector machines). This S4 class is returned by
\code{\link{ensemble_modelling}} or \code{\link{ensemble}}.
}
\section{Slots}{

\describe{
\item{\code{uncertainty}}{raster. Between-algorithm variance map.}

\item{\code{algorithm.correlation}}{data frame. Between-algorithm correlation matrix.}

\item{\code{algorithm.evaluation}}{data frame. Evaluation of the ensemble SDM (available}

\item{\code{sdms}}{list. Individual SDMs used to create the ESDM.
metrics include AUC, Kappa, sensitivity, specificity and proportion of
correctly predicted occurrences) and identification of the optimal threshold
to convert the habitat suitability map into a binary presence/absence map.}
}}

\seealso{
\linkS4class{Algorithm.SDM} an S4 class to represent an SDM based on
 a single algorithm, and \linkS4class{Stacked.SDM} an S4 class for SSDMs.
}
