% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coBCreg.R
\name{coBCReg}
\alias{coBCReg}
\title{General Interface coBCReg model}
\usage{
coBCReg(learner, N = 3, perc.full = 0.7, u = 100, max.iter = 50)
}
\arguments{
\item{learner}{model from parsnip package for training a supervised base classifier
using a set of instances. This model need to have probability predictions}

\item{N}{The number of classifiers used as committee members. All these classifiers
are trained using the \code{gen.learner} function. Default is 3.}

\item{perc.full}{A number between 0 and 1. If the percentage
of new labeled examples reaches this value the self-labeling process is stopped.
Default is 0.7.}

\item{u}{Number of unlabeled instances in the pool. Default is 100.}

\item{max.iter}{Maximum number of iterations to execute in the self-labeling process.
Default is 50.}
}
\description{
coBCReg is based on an
ensemble of N diverse regressors. At each iteration and for each regressor, the
companion committee labels the unlabeled examples then the regressor select
the most informative newly-labeled examples for itself, where the selection confidence
is based on estimating the validation error. The final prediction is the
average of the estimates of the N regressors.
}
\details{
For regression tasks, labeling data is very expensive computationally. Its so slow.
}
\references{
Mohamed Farouk Abdel-Hady, Mohamed Farouk Abdel-Hady and Günther Palm.\cr
\emph{Semi-supervised Learning for Regression with Cotraining by Committee}\cr
Institute of Neural Information Processing
University of Ulm
D-89069 Ulm, Germany
}
