% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRFClassifier.R
\name{GRFClassifierSSLR}
\alias{GRFClassifierSSLR}
\title{General Interface for GRFClassifier (Label propagation using Gaussian Random Fields and Harmonic) model}
\usage{
GRFClassifierSSLR(
  adjacency = "nn",
  adjacency_distance = "euclidean",
  adjacency_k = 6,
  adjacency_sigma = 0.1,
  class_mass_normalization = TRUE,
  scale = FALSE,
  x_center = FALSE
)
}
\arguments{
\item{adjacency}{character; "nn" for nearest neighbour graph or "heat" for radial basis adjacency matrix}

\item{adjacency_distance}{character; distance metric for nearest neighbour adjacency matrix}

\item{adjacency_k}{integer; number of neighbours for the nearest neighbour adjacency matrix}

\item{adjacency_sigma}{double; width of the rbf adjacency matrix}

\item{class_mass_normalization}{logical; Should the Class Mass Normalization heuristic be applied? (default: TRUE)}

\item{scale}{logical; Should the features be normalized? (default: FALSE)}

\item{x_center}{logical; Should the features be centered?}
}
\description{
model from RSSL package
Implements the approach proposed in Zhu et al. (2003) to label propagation over
an affinity graph. Note, as in the original paper, we consider the transductive
scenario, so the implementation does not generalize to out of sample predictions.
The approach minimizes the squared difference in labels assigned to different objects,
where the contribution of each difference to the loss is weighted by the affinity between
the objects. The default in this implementation is to use a knn adjacency matrix based on euclidean
distance to determine this weight. Setting adjacency="heat" will use an RBF kernel over
euclidean distances between objects to determine the weights.
}
\examples{
library(tidyverse)
library(caret)
library(SSLR)
library(tidymodels)

data(wine)


cls <- which(colnames(wine) == "Wine")

#\% LABELED
labeled.index <- createDataPartition(wine$Wine, p = .2, list = FALSE)
wine[-labeled.index,cls] <- NA


m <- GRFClassifierSSLR() \%>\% fit(Wine ~ ., data = wine)

#Accesing model from RSSL
model <- m$model

#Predictions of unlabeled
preds_unlabeled <- m \%>\% predictions()
print(preds_unlabeled)

preds_unlabeled <- m \%>\% predictions(type = "raw")
print(preds_unlabeled)

#Total
y_total <- wine[,cls]
y_total[-labeled.index] <- preds_unlabeled
}
\references{
Zhu, X., Ghahramani, Z. & Lafferty, J., 2003
Semi-supervised learning using gaussian fields and harmonic functions. In Proceedings of the 20th International Conference on Machine Learning. pp. 912-919.
}
