\name{print.repeatedTrain}
\alias{print.repeatedTrain}
\alias{summary.repeatedTrain}
\alias{print.summary.repeatedTrain}
\title{Print and Summary Methods for repeatedTrain Objects}
\description{
  Print and summary \code{\link{methods}} for \code{repeatedTrain} objects.
}
\usage{
\method{print}{repeatedTrain}(x,...)
\method{summary}{repeatedTrain}(object,
                      responseWindow, acquisitionWindow,...)
\method{print}{summary.repeatedTrain}(x,...)

}
\arguments{
  \item{x}{a \code{repeatedTrain} or a \code{summary.repeatedTrain} object.}
  \item{object}{a \code{repeatedTrain} object}
  \item{responseWindow}{a 2 elements vector specifying the begining and
    the end of the neuron response.}
  \item{acquisitionWindow}{a 2 elements vector specifying the begining and
    the end of the acquisition. If \code{missing} values are obtained
    using the \code{\link{floor}} of the smallest spike time and the
    \code{\link{ceiling}} of the largest one.}
  \item{\dots}{additional arguments passed to function
    \code{\link{chisq.test}} or \code{\link{print}}.}
}
\details{
  \code{print.repeatedTrain} calls \code{\link{plot.repeatedTrain}}
}
\value{
  \code{summary.repeatedTrain} returns a LIST of class
  \code{summary.repeatedTrain} with the following components:
  \item{nbRepeates }{The number of repetitions.}
  \item{acquisitionWindow }{The acquisition window.}
  \item{stats }{A matrix with as many rows as repetitions. The first
    column contains the total number of spikes generated by the neuron
    during a given repeat (this column appears under the heading "nb"
    when the object is printed). The second column contains the corresponding
    average discharge rate (this column appears under the heading "nu"
    when the object is printed). If a \code{responseWindow} was specified,
    the third column contains the number of spikes generated by the
    neuron during the response period and the fourth column contains the
    corresponding rate (these column appear under the headings "nbR" and
    "nuR", respectively when the object is printed).}
  \item{globalPval }{The p value of the chi square test for homogeneity
    of the total number of spikes generated accross repetitions. Thats a
  rough stationarity test.}
  \item{responsePval }{If a \code{responseWindow} was specified, the p
    value of the chi square test for homogeneity
    of the number of spikes generated within the "response window" accross repetitions.}
}
\author{Christophe Pouzat  \email{christophe.pouzat@gmail.com} }
\seealso{
  \code{\link{as.repeatedTrain}},
  \code{\link{is.repeatedTrain}},
  \code{\link{plot.repeatedTrain}},
  \code{\link{raster}},
  \code{\link{psth}}
}
\examples{
## Load the Vanillin responses of the first
## cockroach data set
data(CAL1V)
## convert them into repeatedTrain objects
## The stimulus command is on between 4.49 s and 4.99s
CAL1V <- lapply(CAL1V,as.repeatedTrain)
## Generate raster plot for the neurons
raster(CAL1V[["neuron 1"]],c(4.49,4.99))
plot(CAL1V[["neuron 2"]],c(4.49,4.99))
plot(CAL1V[["neuron 3"]],c(4.49,4.99))
## Basic summary of neuron 1
summary(CAL1V[["neuron 1"]])
## Enhanced summary giving a response window between 5 and 5.5s
summary(CAL1V[["neuron 1"]],c(5,5.5))
}
\keyword{ts}
\keyword{survival}
