% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enumeration.R
\name{tt.generator}
\alias{tt.generator}
\title{Enumerate transmission trees for the given pathogen phylogeny, and provide a uniform sample generator}
\usage{
tt.generator(tree, max.unsampled = 0, max.infection.to.sampling = Inf,
  max.sampling.to.noninfectious = Inf, minimum.heights = NULL,
  maximum.heights = NULL, tip.map = tree$tip.label, bigz = FALSE)
}
\arguments{
\item{tree}{A \code{phylo} object}

\item{max.unsampled}{The maximum number of unsampled hosts in the transmission chain. The default is 0.}

\item{max.infection.to.sampling}{The greatest time period (in tree branch length units) that can have elapsed between the infection of a host and a tip from that host appearing. The default is infinity, meaning that no such time limit exists.}

\item{max.sampling.to.noninfectious}{The greatest time period (in tree branch length units) that can have elapsed between a tip from a host appearing and that host becoming noninfectious. If this is 0, a host's infection ends at the time of its last tip. The default is infinity, meaning that no such time limit exists.}

\item{minimum.heights}{A vector of the same length as the set of sampled hosts (at present this is always the number of tips of the tree) dictating the minimum height at which nodes can be allocated to each host. The order is the same as the order of tips in \code{tree$tip.label}. If absent, no such restrictions will be placed. Each must be equal to or smaller than the height of the last tip from the corresponding host. This overrides the given value of \code{max.sampling.to.noninfectious}.}

\item{maximum.heights}{A vector of the same length as the set of sampled hosts (at present this is always the number of tips of the tree) dictating the maximum height at which nodes can be allocated to each host. The order is the same as the order of tips in \code{tree$tip.label}. If absent, no such restrictions will be placed. Each must be equal to or greater than the height of the last tip from the corresponding host. This overrides the given value of \code{max.infection.to.sampling}.}

\item{tip.map}{A vector of the same length as the tip set of the tree listing a string giving the host from which the corresponding sample was derived. If absent, each tip is assumed to come from a different host and the tip names are taken to be the host names.}

\item{bigz}{Use \code{bigz} from \code{gmp} for integers, recommended for large trees}
}
\value{
A list of class \code{tt.info} with the following fields:
\itemize{
\item{\code{tree}}{ The input tree}
\item{\code{tt.count}}{The total number of possible transmission trees.}
\item{\code{hosts}}{ The vector of host names. The order of the elements of this vector is used in the output of \code{sample.tt}.}
\item{\code{height.limits}}{A matrix giving maximum and minimum node heights, in two columns. Rows are ordered by the order of hosts given in the \code{host} field.}
\item{\code{bridge}}{A vector with the same length as the node set of the tree, dictating which nodes have their annotation forced by the tip annotations. Entries are host numbers for nodes whose annotation must be that host, and NA for nodes which can take multiple hosts.}
\item{\code{node.calculations}}{ A list with the same length as the number of nodes of the tree and whose entries are indexed in the same order. If \code{max.unsampled} is 0, each has the following fields (the terminology here comes from the Hall paper):
\itemize{
\item{\code{p}}{ The number of valid partitions of the subtree rooted at this node.}
\item{\code{pstar}}{ The number of valid partitions of the unrooted tree obtained by attaching a single extra tip to the root node of the subtree rooted at this node. Alternatively, if any height constraints are given, a vector of the same length as the set of hosts, giving the number of partitions of the unrooted tree if the extra partition element is subject to the same minimum (but not maximum) height constraint as each host in turn.}
\item{\code{v}}{ A list indexed by the set of hosts, whose entries are the number of valid partitions of the subtree rooted at this node where the root node is in the partition element from each host.}
}
Alternatively, if \code{max.unsampled} is greater than 0, the entries are:
\itemize{
\item{\code{p}}{ A vector of length 1 + \code{max.unsampled} giving the number of valid partitions of the subtree rooted at this node if there are between 0 and \code{max.unsampled} (in order) partition elements containing no tips.}
\item{\code{pstar}}{ A vector of length 1 + \code{max.unsampled} giving the number of valid partitions of the tree obtained from the subtree rooted at this node by adding an extra tip connected to the root node, if there are between 0 and \code{max.unsampled} (in order) partition elements containing no tips.}
\item{\code{ps}}{ As with \code{p}, except this counts only partitions that have the root node in a sampled component (one containing at least one tip).}
\item{\code{pu}}{ As with \code{p}, except this counts only partitions that have the have the root node in an unsampled component (one containing no tip).}
\item{\code{v}}{ A list indexed by the set of hosts and "unsampled", whose entries are, for each host and an unsampled host, a vector of length 1 + \code{max.unsampled} counting the number of partitions that have the root node in that host's component if there are between 0 and \code{max.unsampled} partition elements containing no tips.}
}
}
}
}
\description{
This function produces a list of class \code{tt.generator} which can be used to randomly sample transmission trees for the input phylogeny, and contains information on the number of compatible transmission trees.
}
\examples{
# make a generator for the example tree
generator <- tt.generator(stratus.example.tree)
# count the total number of transmission trees
generator$tt.count
# make a generator for the example tree with at most two unsampled hosts
generator.2us <- tt.generator(stratus.example.tree, max.unsampled = 2)
# make a generator for the example tree with no infection after sampling
generator.limits <- tt.generator(stratus.example.tree, max.sampling.to.noninfectious = 0)
# make a generator with multiple sampling defined by the vector grouping.map
generator.ms <- tt.generator(stratus.example.tree, tip.map = grouping.map)
}
