% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simPop.R
\name{aggPop}
\alias{aggPop}
\alias{pixelPopToArea}
\alias{areaPopToArea}
\title{Aggregate populations to the specified areal level}
\usage{
pixelPopToArea(
  pixelLevelPop,
  eaSamples,
  areas,
  stratifyByUrban = TRUE,
  targetPopMat = NULL,
  doFineScaleRisk = !is.null(pixelLevelPop$fineScaleRisk$p),
  doSmoothRisk = !is.null(pixelLevelPop$smoothRisk$p)
)

areaPopToArea(
  areaLevelPop,
  areasFrom,
  areasTo,
  stratifyByUrban = TRUE,
  doFineScaleRisk = !is.null(areaLevelPop$aggregationResults$pFineScaleRisk),
  doSmoothRisk = !is.null(areaLevelPop$aggregationResults$pSmoothRisk)
)
}
\arguments{
\item{pixelLevelPop}{pixel level population information that we want aggregate. In the same format as output from \code{\link{simPopCustom}}}

\item{eaSamples}{nIntegrationPoint x nsim matrix of the number of enumeration areas per pixel sampled in the input pixel level population}

\item{areas}{character vector of length nIntegrationPoints of area names over which we 
want to aggregate. Can also be subareas}

\item{stratifyByUrban}{whether or not to stratify simulations by urban/rural classification}

\item{targetPopMat}{pixellated grid data frame with variables `lon`, `lat`, `pop` (target population), `area`, `subareas` (if subareaLevel is TRUE), `urban` (if stratifyByUrban is TRUE), `east`, and `north`}

\item{doFineScaleRisk}{whether or not to calculate the fine scale risk in addition to the prevalence. See details}

\item{doSmoothRisk}{Whether or not to calculate the smooth risk in addition to the prevalence. See details}

\item{areaLevelPop}{output of \code{\link{simPopCustom}} containing pixel level information 
about the population of interest}

\item{areasFrom}{character vector of length equal to the number of areas from which 
we would like to aggregate containing the unique names of the areas. 
Can also be subareas, but these are smaller than the "to areas", and 
each "from area" must be entirely contained in a single "to area"}

\item{areasTo}{character vector of length equal to the number of areas from which 
we would like to aggregate containing the names of the areas containing 
with each respective `from' area. Can also be a set of subareas, 
but these are larger than the "from areas".}
}
\value{
A list containing elements `fineScalePrevalence` and `fineScaleRisk`. Each 
of these are in turn lists with aggregated prevalence and risk for the area of 
interest, containg the following elements, were paranethesis indicate the elements 
for the fineScaleRisk model rather than fineScalePrevalence:
\item{p}{Aggregated prevalence (risk), calculated as aggregate of Z divided by 
aggregate of N}
\item{Z}{Aggregated (expected) population numerator}
\item{N}{Aggregated (expected) population denominator}
\item{pUrban}{Aggregated prevalence (risk) in urban part of the area, calculated 
as aggregate of Z divided by aggregate of N}
\item{ZUrban}{Aggregated (expected) population numerator in urban part of the area}
\item{NUrban}{Aggregated (expected) population denominator in urban part of the area}
\item{pRural}{Aggregated prevalence (risk) in rural part of the area, calculated 
as aggregate of Z divided by aggregate of N}
\item{ZRural}{Aggregated (expected) population numerator in rural part of the area}
\item{NRural}{Aggregated (expected) population denominator in rural part of the area}
\item{A}{Aggregation matrix used to aggregate from pixel level to areal level}
\item{AUrban}{Aggregation matrix used to aggregate from pixel level to urban part of the areal level}
\item{ARural}{Aggregation matrix used to aggregate from pixel level to rural part of the areal level}
}
\description{
Takes simulated populations and aggregates 
them to the specified areal level. Also calculates the aggregated risk and prevalence.
}
\section{Functions}{
\itemize{
\item \code{pixelPopToArea()}: Aggregate from pixel to areal level

\item \code{areaPopToArea()}: Aggregate areal populations to another areal level

}}
\examples{
\dontrun{
##### Now we make a model for the risk. We will use an SPDE model with these 
##### parameters for the linear predictor on the logist scale, which are chosen 
##### to be of practical interest:
beta0=-2.9 # intercept
gamma=-1 # urban effect
rho=(1/3)^2 # spatial variance
effRange = 400 # effective spatial range in km
sigmaEpsilon=sqrt(1/2.5) # cluster (nugget) effect standard deviation

# simulate the population! Note that this produces multiple dense 
# nEA x nsim and nIntegrationPoint x nsim matrices. In the future 
# sparse matrices will and chunk by chunk computations may be incorporated.
simPop = simPopSPDE(nsim=1, easpa=easpaKenyaNeonatal, 
                    popMat=popMatKenya, targetPopMat=popMatKenyaNeonatal, 
                    poppsub=poppsubKenya, spdeMesh=kenyaMesh, 
                    margVar=rho, sigmaEpsilonSq=sigmaEpsilon^2, 
                    gamma=gamma, effRange=effRange, beta0=beta0, 
                    seed=123, inla.seed=12, nHHSampled=25, 
                    stratifyByUrban=TRUE, subareaLevel=TRUE, 
                    doFineScaleRisk=TRUE, 
                    min1PerSubarea=TRUE)

pixelPop = simPop$pixelPop
subareaPop = pixelPopToArea(pixelLevelPop=pixelPop, eaSamples=pixelPop$eaSamples, 
  areas=popMatKenya$subarea, stratifyByUrban=TRUE, 
  targetPopMat=popMatKenyaNeonatal, doFineScaleRisk=TRUE)

# get areas associated with each subarea for aggregation
tempAreasFrom = popMatKenya$subarea
tempAreasTo = popMatKenya$area
areasFrom = sort(unique(tempAreasFrom))
areasToI = match(areasFrom, tempAreasFrom)
areasTo = tempAreasTo[areasToI]

# do the aggregation from subareas to areas
outAreaLevel = areaPopToArea(areaLevelPop=subareaPop, 
  areasFrom=areasFrom, areasTo=areasTo, 
  stratifyByUrban=TRUE, doFineScaleRisk=TRUE)
}
}
\references{
In Preparation
}
\seealso{
\code{\link{areaPopToArea}}
}
\author{
John Paige
}
