% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigexp.R
\name{bigexp_train}
\alias{bigexp_train}
\title{Build a spec and prepare training data in one call}
\usage{
bigexp_train(formula, data, ...)
}
\arguments{
\item{formula}{Main-effects formula (e.g., \code{y ~ X1 + X2 + G} or \code{y ~ .}).}

\item{data}{Training data frame (used to lock types/levels and prepare).}

\item{...}{Additional arguments forwarded to \code{\link[=bigexp_terms]{bigexp_terms()}}
(e.g., \code{factorial_order}, \code{discrete_threshold},
\code{include_pure_cubic}, \code{include_pc_3way}, \code{intercept}).}
}
\value{
A list with components:
\itemize{
\item \code{spec} — the "bigexp_spec" object.
\item \code{formula} — the expanded formula (\code{spec$formula}).
\item \code{data} — the coerced training data ready for modeling.
}
}
\description{
Convenience wrapper around \code{\link[=bigexp_terms]{bigexp_terms()}} and \code{\link[=bigexp_prepare]{bigexp_prepare()}}. It creates
the deterministic expansion spec from the training data and immediately
prepares that same training data to match the locked types/levels.
Prefer the two-step API in documentation, but this is handy for quick scripts.
}
\examples{
# tr <- bigexp_train(y ~ X1 + X2 + X3, dat, factorial_order = 3)
# fit <- SVEMnet(tr$formula, data = tr$data, ...)
}
