% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorical_col_chart.R
\name{categorical_col_chart}
\alias{categorical_col_chart}
\title{Plot Counts of Categorical Variables
Create a ggplot2 column chart of categorical variables with proportions, in ascending order.}
\usage{
categorical_col_chart(df, grouping_var)
}
\arguments{
\item{df}{A dataframe with categorical variables}

\item{grouping_var}{a categorical variable by which to group the count by}
}
\value{
a ggplot2 object
}
\description{
Plot Counts of Categorical Variables
Create a ggplot2 column chart of categorical variables with proportions, in ascending order.
}
\examples{
library(SangerTools)
library(dplyr)
library(ggplot2)
# Group by Age Band
health_data <- SangerTools::PopHealthData
health_data \%>\%
 dplyr::filter(Smoker==1) \%>\%
 SangerTools::categorical_col_chart(AgeBand) + labs(x="Ethnicity", y="Patient Number")
}
