#' Perform cell clustering based on scDHA method
#'
#' Cluster cells based on scDHA methods to get cluster labels
#'
#' @usage cluster_cells(ScRNA_filtered, Normalize = TRUE, k=NULL, n=5000)
#'
#' @param ScRNA_filtered ScRNA-seq data set generated by filter_ScRNA function
#'
#' @param Normalize Boolean parameter whether to apply log10 normalization for the data or not
#'
#' @param k Number of clusters if there is a prior knowledge about that
#'
#' @param n Number of genes to keep after feature selection step
#'
#' @export
#'
#' @author Mohamed Soudy \email{Mohmedsoudy2009@gmail.com}
#'
#' @returns a vector that contains the cell labels
#'
cluster_cells <- function(ScRNA_filtered, Normalize = TRUE, k = NULL, n=5000)
{
  if (Normalize)
    ScRNA_filtered <- log10(ScRNA_filtered + 1)
  ScRNA_filtered <- t(ScRNA_filtered)
  if (is.null(k))
  {
    cluster_results <- scDHA(ScRNA_filtered, seed = 1, n = n)
  }else{
    cluster_results <- scDHA(ScRNA_filtered, seed = 1, k = k, n = n)
  }
  clusters <- cluster_results$cluster
  return(clusters)
}
#' Evaluate the clustering if you have the original labels
#'
#' @usage evaluate_clustering(cluster_labels, original_labels)
#'
#' @param cluster_labels Cluster labels generated by cluster_cells functions or user-defined
#'
#' @param original_labels Original labels of the ScRNA-seq data
#'
#' @examples evaluate_clustering(c(1,1,1,1,2,2,3,3), c(1,1,1,1,3,3,3,2))
#'
#' @export
#'
#' @author Mohamed Soudy \email{Mohmedsoudy2009@gmail.com}
#'
#' @returns ARI of clustering 'a value between 0 and 1' 1 indicates best clustering
#'
evaluate_clustering <- function(cluster_labels, original_labels)
{
  message(paste0("ARI of clustering is: ", adjustedRandIndex(cluster_labels, original_labels)))
}
