% Generated by roxygen2 (4.0.2): do not edit by hand
\encoding{UTF-8}
\name{info}
\alias{info}
\title{Get Information on Data Objects}
\usage{
info(data, show, ignore)
}
\arguments{
\item{data}{the data frame to be detailed.}

\item{show}{the selection of columns from \code{data}, if not all.}

\item{ignore}{columns from \code{data} to prevent of showing.}
}
\description{
Get Information on Data Objects
}
\examples{
data(titanic)
## Wildcard for variables
info(titanic, "C*") # Show all variables starting with 'C'
## Subset of variables
info(titanic, show = CLASS:SEX) # Same results
info(titanic, show = 1:3)
## Exclusion using wildcard.
info(titanic, ignore = "C*")
}

