% Generated by roxygen2 (4.0.2): do not edit by hand
\encoding{UTF-8}
\name{variation}
\alias{variation}
\title{Pearson's Coefficient of Variation}
\usage{
variation(x)
}
\arguments{
\item{x}{A numeric vector.}
}
\value{
The coefficient of variation.
}
\description{
Compute the absolute \bold{coefficient of variation} \bold{cv} as proposed by Karl Pearson, which is given by the division of standard deviation by the mean. The CV reflects a normalized measure of the dispersion of a given probability distribution. Conversely, distributions with \eqn{cv < 1} are considered \dQuote{low-variance}, while those with \eqn{cv > 1} \dQuote{high-variance}.
}
\details{
\eqn{\frac{sd(x)}{mean(x)} = cv}, which is the inverse of signal-to-noise ratio.
}
\examples{
myvar <- sample(100)
variation(myvar)
}
\author{
Daniel Marcelino, \email{dmarcelino@live.com}
}
\keyword{Basics}
\keyword{Descriptive}
\keyword{Stats}
\keyword{The}

