% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/draw.norm.R
\encoding{UTF-8}
\name{draw.norm}
\alias{draw.norm}
\title{Shades Normal Distribuion}
\usage{
draw.norm(below = NULL, above = NULL, pcts = c(0.025, 0.975), mu = 0,
  sigma = 1, numpts = 500, color = "gray", dens = 40,
  justabove = FALSE, justbelow = FALSE, lines = FALSE, between = NULL,
  outside = NULL)
}
\arguments{
\item{below}{sets a lower endpoint.}

\item{above}{sets an upper endpoint.}

\item{pcts}{the}

\item{mu}{the mean.}

\item{sigma}{standard deviations.}

\item{numpts}{the number os points/observations to drawn upon.}

\item{color}{the color of the area.}

\item{dens}{the density of the color.}

\item{justabove}{just plots the upper tail.}

\item{justbelow}{just plots the lower tail.}

\item{lines}{to draw lines.}

\item{between}{plots between specified points.}

\item{outside}{alternative "outside" area.}
}
\value{
A plot with a normal distribution density with shaded areas
}
\description{
Produces a plot of a normal density distribution with shaded areas.
}
\examples{
draw.norm()
draw.norm(below=-1.5)
draw.norm(below=-1.5,justbelow=TRUE)
draw.norm(above=1.5, justabove=TRUE)
draw.norm(below=-1.5,above=1.5)
draw.norm(between=c(-4,0),color="black")
draw.norm(between=c(0,4),color="black")
draw.norm(between=c(-1,+1),color="darkgray")
title("P[-1 < z < 1] = 68\%")
draw.norm(between=c(-2,+2),color="darkgray")
title("P[-2 < z < 2] = 95\%")
draw.norm(between=c(-3,+3),color="darkgray")
title("P[-3 < z < 3] = 99.7\%")
draw.norm(between = c(-1.75, 0, 2, 0.5, -1))  ## Plots between specified points
draw.norm(below=50,justbelow=TRUE,color="black",mu=47.3,sigma=9.3)

## Can plot one and then another on top of it using lines = TRUE
draw.norm(mu=2, sigma=10, outside=c(-3, 12), dens=15)
draw.norm(mu=2, sigma=15, between=c(-3, 12),lines=TRUE, col="blue",dens=15)
## Example: Plotting a Hypothesis Test for the mean
## Truth:      mu.true  = 8
## Hypothesis: mu.ho    = 6
## Generate Data Under Truth
mu.true = 5 ## Alternative Mean
mu.ho   = 6
sig     = 8
N       = 250 ## Sample Size

std.err = sig/sqrt(N)
crits = qnorm(c(0.025,0.975),mean=mu.ho, sd = std.err)
draw.norm(outside = crits, mu = mu.ho, sigma = std.err,dens=15)
draw.norm(between = crits, mu = mu.true, sigma = std.err, lines=TRUE, color="green",dens=15)
}

