% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/shift.R
\encoding{UTF-8}
\name{shift}
\alias{shift}
\alias{shift.data.frame}
\alias{shift.default}
\title{Shifts elements of a vector left or right by N positions (Lag or Lead).}
\usage{
shift(x, ...)

\method{shift}{default}(x, n = 1, pad = TRUE, wrap = TRUE, ...)

\method{shift}{data.frame}(x, ...)
}
\arguments{
\item{x}{A vector to be operated on}

\item{n}{Number of rows to shift by (if negative, shift to right instead of
left)}

\item{pad}{Whether to pad with NAs or not.  pad does nothing unless wrap is
false, in which case it specifies whether to pad with NAs}

\item{wrap}{Whether to wrap elements or not (adds the entry at the beginning to the end)}

\item{\dots}{Other items to pass along}
}
\value{
vector of the same type as vec
}
\description{
Shifts elements of a vector left or right by N positions (Lag or Lead).
}
\examples{
l <- list(a = sample(LETTERS,3), b = runif(5), c = runif(15));
df <- as.data.frame(l);
shift(df$c, 1)
}

