% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TESTS.R
\name{bartels.rank}
\alias{bartels.rank}
\alias{bartels.rank.default}
\title{Bartels Rank Test of Randomness}
\usage{
bartels.rank(x, alternative = "two.sided", pvalue = "normal")

\method{bartels.rank}{default}(x, alternative = "two.sided",
  pvalue = "normal")
}
\arguments{
\item{x}{A numeric vector of data values.}

\item{alternative}{A method for hypothesis testing, must be one of "two.sided" (default), "left.sided" or "right.sided".}

\item{pvalue}{A method for asymptotic aproximation used to compute the p-value.}
}
\value{
\item{statistic}{ The value of the RVN statistic test and the theoretical mean value and variance of the RVN statistic test.}
\item{n}{ the sample size, after the remotion of consecutive duplicate values.}
\item{p.value}{the asymptotic p-value.}
\item{method}{a character string indicating the test performed.}
\item{data.name}{a character string giving the name of the data.}
\item{alternative}{a character string describing the alternative.}
}
\description{
Performs Bartels rank test of randomness. The default method for testing the null hypothesis of randomness is \code{two.sided}. By using the alternative \code{left.sided}, the null hypothesis is tested against a trend. By using the alternative \code{right.sided}, the null hypothesis of randomness is tested against a systematic oscillation in the observed data.
}
\details{
Missing values are by default removed.
The RVN test statistic is
\deqn{RVN=\frac{\sum_{i=1}^{n-1}(R_i-R_{i+1})^2}{\sum_{i=1}^{n}\left(R_i-(n+1)/2\right)^2}}{RVN=\sum(R_i-R_{i+1})^2 / \sum(R_i-(n+1)/2)^2}
where \eqn{R_i=rank(X_i), i=1,\dots, n}{R_i=rank(X_i), i=1,...,n}. It is known that \eqn{(RVN-2)/\sigma} is asymptotically standard normal, where \eqn{\sigma^2=\frac{4(n-2)(5n^2-2n-9)}{5n(n+1)(n-1)^2}}{\sigma^2=[4(n-2)(5n^2-2n-9)]/[5n(n+1)(n-1)^2]}.
}
\examples{
# Example 5.1 in Gibbons and Chakraborti (2003), p.98.
# Annual data on total number of tourists to the United States for 1970-1982.
 years <- 1970:1982
tourists <- c(12362, 12739, 13057, 13955, 14123,  15698, 17523,
 18610, 19842, 20310, 22500, 23080, 21916)

 # See it graphically
 qplot(factor(years), tourists)+ geom_point()

# Test the null against a trend
 bartels.rank(tourists, alternative="left.sided", pvalue="beta")
}
\references{
Bartels, R. (1982). The Rank Version of von Neumann's Ratio Test for Randomness, \emph{Journal of the American Statistical Association}, \bold{77}(377), 40-46.

Gibbons, J.D. and Chakraborti, S. (2003). \emph{Nonparametric Statistical Inference}, 4th ed. (pp. 97-98). URL: \url{http://books.google.pt/books?id=dPhtioXwI9cC&lpg=PA97&ots=ZGaQCmuEUq}
}
\keyword{Tests}

