% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/electoralTool.R
\encoding{UTF-8}
\name{herfindahl}
\alias{herfindahl}
\title{Herfindahl Index of Concentration}
\usage{
herfindahl(x, n = rep(1, length(x)), parameter = 1, na.rm = FALSE, ...)

herfindahl(x, n = rep(1, length(x)), parameter = 1, na.rm = FALSE, ...)
}
\arguments{
\item{x}{A vector of data values of non-negative elements.}

\item{n}{A vector of frequencies of the same length as \code{x}.}

\item{parameter}{A parameter of the concentration measure (if set to \code{NULL} the default parameter of the respective measure is used).}

\item{na.rm}{A logical. Should missing values be removed? The Default is set to \code{na.rm=FALSE}.}

\item{\dots}{Additional arguements (currently ignored)}
}
\description{
Calculates the Herfindahl Index of concentration.
}
\details{
This index is also known as the \emph{Simpson Index} in ecology, the \emph{Herfindahl-Hirschman Index (HHI)} in economics, and as the \emph{Effective Number of Parties (ENP)} in political science.
}
\examples{
# generate a vector (of incomes)
x <- c(778, 815, 857, 888, 925, 930, 965, 990, 1012)

# compute the Herfindahl coefficient with parameter=1
herfindahl(x, parameter=1)
}
\references{
Cowell, F. A. (2000) Measurement of Inequality in Atkinson, A. B. / Bourguignon, F. (Eds): \emph{Handbook of Income Distribution}. Amsterdam.

Cowell, F. A. (1995) \emph{Measuring Inequality} Harvester Wheatshef: Prentice Hall.
}
\seealso{
\code{\link{atkinson}}, \code{\link{rosenbluth}}, \code{\link{politicalDiversity}}, \code{\link{gini}}. For more details see the Indices vignette: \code{vignette("Indices", package = "SciencesPo")}.
}

