% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Themes.R
\encoding{UTF-8}
\name{theme_pub}
\alias{theme_pub}
\title{The Default Theme}
\usage{
theme_pub(legend = "bottom", font_family = "sans", font_size = 13,
  line_width = 0.5, axis.line.x = element_line(),
  axis.line.y = element_blank())
}
\arguments{
\item{legend}{Enables to set legend position, default is "bottom".}

\item{font_family}{Default font family.}

\item{font_size}{Overall font size. Default is 14.}

\item{line_width}{Default line size.}

\item{axis.line.x}{Enables to set x axis line.}

\item{axis.line.y}{Enables to set y axis line.}
}
\value{
The theme.
}
\description{
After loading the SciencesPo package, this theme will be
set to default for all subsequent graphs made with ggplot2.
}
\examples{
ggplot(diamonds,aes(cut, group=1)) + geom_bar()+
geom_freqpoly(stat="count",size=2) + scale_color_pub() + theme_pub(line_width=1)

dat <- data.frame()
for(i in 1:4)
dat <- rbind(dat, data.frame(set=i, x=anscombe[,i], y=anscombe[,i+4]))

ggplot(dat, aes(x, y)) + geom_point(size=5, color="red",
fill="orange", shape=21) + geom_smooth(method="lm", fill=NA,
fullrange=TRUE) + facet_wrap(~set, ncol=2)
}
\seealso{
\code{\link[ggplot2]{theme}}, \code{\link{theme_538}}, \code{\link{theme_blank}}.
}

