% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Recode.R
\encoding{UTF-8}
\name{Recode}
\alias{Recode}
\alias{Recode.default}
\title{Recode or Replace Values With New Values}
\usage{
Recode(x, old, into, warn = TRUE)

\method{Recode}{default}(x, old, into, warn = TRUE)
}
\arguments{
\item{x}{The vector whose values will be recoded.}

\item{old}{the old value or a vector of old values (numeric/factor/string).}

\item{into}{the new value or a vector of replacement values (1 to 1 recoding).}

\item{warn}{A logical to print a message if any of the
old values are not actually present in \code{x}.}
}
\description{
Recodes a value or a vector of values.
}
\examples{
x <- LETTERS[1:5]
Recode(x, c("B", "D"), c("Beta", "Delta"))

# On numeric vectors
x <- c(1, 4, 5, 9)
Recode(x, old = c(1, 4, 5, 9), into = c(10, 40, 50, 90))

}
\keyword{Manipulation}

