% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegEnvIneq.R
\name{EnvResamplePlot}
\alias{EnvResamplePlot}
\title{A function to test environmental inequality indices by resampling}
\usage{
EnvResamplePlot(ResampleTest, var = 1,  coldist = "red", colind = "blue", legend = TRUE,
legendpos = "top", cex.legend = 1, bty = "o")
}
\arguments{
\item{ResampleTest}{- a ResampleTest object produced with ResampleTest function}

\item{var}{- the number of the variable to be plot}

\item{coldist}{- color used to plot the simulated distribution}

\item{colind}{- color used to plot the index}

\item{legend}{- logical parameter, to control the legend's plots}

\item{legendpos}{- a character string giving the legend's position: 'bottomright', 'bottom',
'bottomleft', 'left', 'topleft', 'top', 'topright', 'right' and 'center'.}

\item{cex.legend}{- a numerical value giving the amount by which plotting text and symbols
in legend should be magnified relative to the default.}

\item{bty}{- a character string which determines the type of box of the legend:
'o' (by default), 'l', '7', 'c', 'u', or ']'}
}
\value{
A plot with resampling distribution
corresponding upper case letter. A value of 'n' suppresses the box.
}
\description{
Plot of resampling simulations results.
}
\examples{
data(segdata, package = "OasisR")
# segdata - theoretical distributions on a 10x10 grid map
# We consider A1 - population distribution and A2 - amenity distribution
testoutput <- EnvResampleTest (x = segdata@data$A1, a = segdata@data$A2, spatobj = segdata,
fun = "EDfunc", vers = "contig", queen = FALSE)
EnvResamplePlot(testoutput)
}
\references{
Schaeffer Y. and Tivadar M. (2019)
Measuring Environmental Inequalities: Insights from the Residential
Segregation Literature. \emph{Ecological Economics}, 164, 106329

Tivadar M. (2019)
OasisR: An R Package to Bring Some Order to the World of Segregation Measurement.
\emph{Journal of Statistical Software},  89 (7), pp. 1-39
}
\seealso{
\code{\link{EDfunc}}, \code{\link{ECfunc}},
\code{\link{EnvResampleTest}}
}
