% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cond_mean_fn.R
\name{Cond_mean_fn}
\alias{Cond_mean_fn}
\title{Estimate Subject Predicted Mean Outcome}
\usage{
Cond_mean_fn(mu, theta, alpha)
}
\arguments{
\item{mu}{mean}

\item{theta}{size}

\item{alpha}{sensitivity}
}
\value{
a list containing
\eqn{\frac{E[ Y exp(\alpha Y) ]}{E[ exp(\alpha Y)]}}{(E[ Y*exp(\alpha Y) ]/(E[exp(\alpha Y)])}
and \verb{$E[ exp(\\alpha Y) ]$}
for Y a (truncated version of) a negative binomial having mean \code{mu} and
size \code{theta}.
}
\description{
This function is used to get a subject's predicted mean outcome under a given
sensitivity parameter value \code{alpha}.
It is specific to the outcome model that we used on the
ARC data (which was negative binomial), and specific to the
tilting function alpha*Y(t), so would need to be changed if
using a different outcome model or different tilting function.
}
\keyword{internal}
