% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phc.R
\name{phc}
\alias{phc}
\title{CDF of Higher Criticism statitic under the null hypothesis.}
\usage{
phc(q, n, beta, LS = F, ZW = F)
}
\arguments{
\item{q}{- quantile, must be a scalar.}

\item{n}{- dimension parameter, i.e. the number of input statitics to construct HC statistic.}

\item{beta}{- search range parameter . Beta must be between 1/n and 1.}

\item{LS}{- if LS = T, then method of Li and Siegmund (2015) will be implemented.When n and q is very large, approximation method is prefered.}

\item{ZW}{- if ZW = T, then approximation method of Zhang and Wu will be implemented.}
}
\value{
The left-tail probability of the null distribution of HC statistic at the given quantile.
}
\description{
CDF of Higher Criticism statitic under the null hypothesis.
}
\examples{
pval <- runif(10)
hcstat <- stat.phi(pval, 2, 0.5)$value
phc(q=hcstat, n=10, beta=0.5)
}
\references{
1. Hong Zhang, Jiashun Jin and Zheyang Wu. "Distributions and Statistical Power of Optimal
Signal Detection Methods in Finite Samples", submitted.

2. Donoho, David; Jin, Jiashun. "Higher criticism for detecting sparse heterogeneous mixtures". Annals of Statistics 32 (2004).

3. Li, Jian; Siegmund, David. "Higher criticism: p-values and criticism". Annals of Statistics 43 (2015).
}
\seealso{
\code{\link{stat.hc}} for the definition of the statistic.
}

