% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimensional_reduction_utilities.R
\name{PCTopGenes}
\alias{PCTopGenes}
\title{Find genes with highest PCA scores}
\usage{
PCTopGenes(object, pc.use = 1, num.genes = 30, use.full = FALSE,
  do.balanced = FALSE)
}
\arguments{
\item{object}{Seurat object}

\item{pc.use}{Principal components to use}

\item{num.genes}{Number of genes to return}

\item{use.full}{Use the full PCA (projected PCA). Default is FALSE}

\item{do.balanced}{Return an equal number of genes with both + and - PC scores.}
}
\value{
Returns a vector of genes
}
\description{
Return a list of genes with the strongest contribution to a set of principal
components
}
\examples{
pbmc_small
PCTopGenes(object = pbmc_small, pc.use = 1)
# After projection:
PCTopGenes(object = pbmc_small, pc.use = 1, use.full = TRUE)

}
