% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{CellPlot}
\alias{CellPlot}
\title{Cell-cell scatter plot}
\usage{
CellPlot(object, cell1, cell2, gene.ids = NULL, col.use = "black",
  nrpoints.use = Inf, pch.use = 16, cex.use = 0.5, do.hover = FALSE,
  do.identify = FALSE, ...)
}
\arguments{
\item{object}{Seurat object}

\item{cell1}{Cell 1 name (can also be a number, representing the position in
object@cell.names)}

\item{cell2}{Cell 2 name (can also be a number, representing the position in
object@cell.names)}

\item{gene.ids}{Genes to plot (default, all genes)}

\item{col.use}{Colors to use for the points}

\item{nrpoints.use}{Parameter for smoothScatter}

\item{pch.use}{Point symbol to use}

\item{cex.use}{Point size}

\item{do.hover}{Enable hovering over points to view information}

\item{do.identify}{Opens a locator session to identify clusters of cells.
points to reveal gene names (hit ESC to stop)}

\item{\dots}{Additional arguments to pass to smoothScatter}
}
\value{
No return value (plots a scatter plot)
}
\description{
Creates a plot of scatter plot of genes across two single cells. Pearson
correlation between the two cells is displayed above the plot.
}
\examples{
CellPlot(object = pbmc_small, cell1 = 'ATAGGAGAAACAGA', cell2 = 'CATCAGGATGCACA')

}
