% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{CreateDimReducObject}
\alias{CreateDimReducObject}
\alias{SetDimReduction}
\title{Create a DimReduc object}
\usage{
CreateDimReducObject(embeddings = new(Class = "matrix"),
  loadings = new(Class = "matrix"), projected = new(Class = "matrix"),
  assay = NULL, stdev = numeric(), key = NULL, jackstraw = NULL,
  misc = list())
}
\arguments{
\item{embeddings}{A matrix with the cell embeddings}

\item{loadings}{A matrix with the feature loadings}

\item{projected}{A matrix with the projected feature loadings}

\item{assay}{Assay used to calculate this dimensional reduction}

\item{stdev}{Standard deviation (if applicable) for the dimensional reduction}

\item{key}{A character string to facilitate looking up features from a
specific DimReduc}

\item{jackstraw}{Results from the JackStraw function}

\item{misc}{list for the user to store any additional information associated
with the dimensional reduction}
}
\description{
Create a DimReduc object
}
\examples{
data <- GetAssayData(pbmc_small[["RNA"]], slot = "scale.data")
pcs <- prcomp(x = data)
pca.dr <- CreateDimReducObject(
  embeddings = pcs$rotation,
  loadings = pcs$x,
  stdev = pcs$sdev,
  key = "PC",
  assay = "RNA"
)

}
