% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{SubsetData}
\alias{SubsetData}
\alias{SubsetData.Assay}
\alias{SubsetData.Seurat}
\title{Return a subset of the Seurat object}
\usage{
SubsetData(object, ...)

\method{SubsetData}{Assay}(object, cells = NULL, subset.name = NULL,
  low.threshold = -Inf, high.threshold = Inf, accept.value = NULL,
  ...)

\method{SubsetData}{Seurat}(object, assay = NULL, cells = NULL,
  subset.name = NULL, ident.use = NULL, ident.remove = NULL,
  low.threshold = -Inf, high.threshold = Inf, accept.value = NULL,
  max.cells.per.ident = Inf, random.seed = 1, ...)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{cells}{A vector of cell names to use as a subset. If NULL
(default), then this list will be computed based on the next three
arguments. Otherwise, will return an object consissting only of these cells}

\item{subset.name}{Parameter to subset on. Eg, the name of a gene, PC_1, a
column name in object@meta.data, etc. Any argument that can be retreived
using FetchData}

\item{low.threshold}{Low cutoff for the parameter (default is -Inf)}

\item{high.threshold}{High cutoff for the parameter (default is Inf)}

\item{accept.value}{Returns cells with the subset name equal to this value}

\item{assay}{Assay to subset on}

\item{ident.use}{Create a cell subset based on the provided identity classes}

\item{ident.remove}{Subtract out cells from these identity classes (used for
filtration)}

\item{max.cells.per.ident}{Can be used to downsample the data to a certain
max per cell ident. Default is INF.}

\item{random.seed}{Random seed for downsampling}
}
\value{
Returns a Seurat object containing only the relevant subset of cells
}
\description{
Creates a Seurat object containing only a subset of the cells in the
original object. Takes either a list of cells to use as a subset, or a
parameter (for example, a gene), to subset on.
}
\examples{
\dontrun{
pbmc1 <- SubsetData(object = pbmc_small, cells = colnames(x = pbmc_small)[1:40])
pbmc1
}

}
