% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/objects.R
\name{Embeddings}
\alias{Embeddings}
\alias{Embeddings.DimReduc}
\alias{Embeddings.Seurat}
\title{Get cell embeddings}
\usage{
Embeddings(object, ...)

\method{Embeddings}{DimReduc}(object, ...)

\method{Embeddings}{Seurat}(object, reduction = "pca", ...)
}
\arguments{
\item{object}{An object}

\item{...}{Arguments passed to other methods}

\item{reduction}{Name of reduction to pull cell embeddings for}
}
\description{
Get cell embeddings
}
\examples{
# Get the embeddings directly from a DimReduc object
Embeddings(object = pbmc_small[["pca"]])[1:5, 1:5]

# Get the embeddings from a specific DimReduc in a Seurat object
Embeddings(object = pbmc_small, reduction = "pca")[1:5, 1:5]

}
